/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;

public abstract class PackedCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -3151899011275603L;
    protected int dimension;
    protected int measures;
    protected transient SoftReference<Coordinate[]> coordRef;

    protected PackedCoordinateSequence(int dimension, int measures) {
        if (dimension - measures < 2) {
            throw new IllegalArgumentException("Must have at least 2 spatial dimensions");
        }
        this.dimension = dimension;
        this.measures = measures;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int getMeasures() {
        return this.measures;
    }

    @Override
    public Coordinate getCoordinate(int i2) {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords[i2];
        }
        return this.getCoordinateInternal(i2);
    }

    @Override
    public Coordinate getCoordinateCopy(int i2) {
        return this.getCoordinateInternal(i2);
    }

    @Override
    public void getCoordinate(int i2, Coordinate coord) {
        coord.x = this.getOrdinate(i2, 0);
        coord.y = this.getOrdinate(i2, 1);
        if (this.hasZ()) {
            coord.setZ(this.getZ(i2));
        }
        if (this.hasM()) {
            coord.setM(this.getM(i2));
        }
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        Coordinate[] coords = this.getCachedCoords();
        if (coords != null) {
            return coords;
        }
        coords = new Coordinate[this.size()];
        for (int i2 = 0; i2 < coords.length; ++i2) {
            coords[i2] = this.getCoordinateInternal(i2);
        }
        this.coordRef = new SoftReference<Coordinate[]>(coords);
        return coords;
    }

    private Coordinate[] getCachedCoords() {
        if (this.coordRef != null) {
            Coordinate[] coords = this.coordRef.get();
            if (coords != null) {
                return coords;
            }
            this.coordRef = null;
            return null;
        }
        return null;
    }

    @Override
    public double getX(int index2) {
        return this.getOrdinate(index2, 0);
    }

    @Override
    public double getY(int index2) {
        return this.getOrdinate(index2, 1);
    }

    @Override
    public abstract double getOrdinate(int var1, int var2);

    public void setX(int index2, double value2) {
        this.coordRef = null;
        this.setOrdinate(index2, 0, value2);
    }

    public void setY(int index2, double value2) {
        this.coordRef = null;
        this.setOrdinate(index2, 1, value2);
    }

    public String toString() {
        return CoordinateSequences.toString(this);
    }

    protected Object readResolve() throws ObjectStreamException {
        this.coordRef = null;
        return this;
    }

    protected abstract Coordinate getCoordinateInternal(int var1);

    @Override
    public abstract Object clone();

    @Override
    public abstract PackedCoordinateSequence copy();

    @Override
    public abstract void setOrdinate(int var1, int var2, double var3);

    public static class Float
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = -2902252401427938986L;
        float[] coords;

        public Float(float[] coords, int dimension, int measures) {
            super(dimension, measures);
            if (coords.length % dimension != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.coords = coords;
        }

        public Float(double[] coords, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new float[coords.length];
            for (int i2 = 0; i2 < coords.length; ++i2) {
                this.coords[i2] = (float)coords[i2];
            }
        }

        public Float(Coordinate[] coordinates, int dimension) {
            this(coordinates, dimension, Math.max(0, dimension - 3));
        }

        public Float(Coordinate[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.coords = new float[coordinates.length * dimension];
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                int offset = i2 * dimension;
                this.coords[offset] = (float)coordinates[i2].x;
                this.coords[offset + 1] = (float)coordinates[i2].y;
                if (dimension >= 3) {
                    this.coords[offset + 2] = (float)coordinates[i2].getOrdinate(2);
                }
                if (dimension < 4) continue;
                this.coords[offset + 3] = (float)coordinates[i2].getOrdinate(3);
            }
        }

        public Float(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new float[size * this.dimension];
        }

        @Override
        public Coordinate getCoordinateInternal(int i2) {
            double x = this.coords[i2 * this.dimension];
            double y = this.coords[i2 * this.dimension + 1];
            if (this.dimension == 2 && this.measures == 0) {
                return new CoordinateXY(x, y);
            }
            if (this.dimension == 3 && this.measures == 0) {
                double z = this.coords[i2 * this.dimension + 2];
                return new Coordinate(x, y, z);
            }
            if (this.dimension == 3 && this.measures == 1) {
                double m = this.coords[i2 * this.dimension + 2];
                return new CoordinateXYM(x, y, m);
            }
            if (this.dimension == 4) {
                double z = this.coords[i2 * this.dimension + 2];
                float m = this.coords[i2 * this.dimension + 3];
                return new CoordinateXYZM(x, y, z, m);
            }
            return new Coordinate(x, y);
        }

        public float[] getRawCoordinates() {
            return this.coords;
        }

        @Override
        public int size() {
            return this.coords.length / this.dimension;
        }

        @Override
        public Object clone() {
            return this.copy();
        }

        @Override
        public Float copy() {
            float[] clone = Arrays.copyOf(this.coords, this.coords.length);
            return new Float(clone, this.dimension, this.measures);
        }

        @Override
        public double getOrdinate(int index2, int ordinate) {
            return this.coords[index2 * this.dimension + ordinate];
        }

        @Override
        public void setOrdinate(int index2, int ordinate, double value2) {
            this.coordRef = null;
            this.coords[index2 * this.dimension + ordinate] = (float)value2;
        }

        @Override
        public Envelope expandEnvelope(Envelope env) {
            for (int i2 = 0; i2 < this.coords.length; i2 += this.dimension) {
                if (i2 + 1 >= this.coords.length) continue;
                env.expandToInclude(this.coords[i2], this.coords[i2 + 1]);
            }
            return env;
        }
    }

    public static class Double
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 5777450686367912719L;
        double[] coords;

        public Double(double[] coords, int dimension, int measures) {
            super(dimension, measures);
            if (coords.length % dimension != 0) {
                throw new IllegalArgumentException("Packed array does not contain an integral number of coordinates");
            }
            this.coords = coords;
        }

        public Double(float[] coords, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new double[coords.length];
            for (int i2 = 0; i2 < coords.length; ++i2) {
                this.coords[i2] = coords[i2];
            }
        }

        public Double(Coordinate[] coordinates, int dimension) {
            this(coordinates, dimension, Math.max(0, dimension - 3));
        }

        public Double(Coordinate[] coordinates, int dimension, int measures) {
            super(dimension, measures);
            if (coordinates == null) {
                coordinates = new Coordinate[]{};
            }
            this.coords = new double[coordinates.length * this.dimension];
            for (int i2 = 0; i2 < coordinates.length; ++i2) {
                int offset = i2 * dimension;
                this.coords[offset] = coordinates[i2].x;
                this.coords[offset + 1] = coordinates[i2].y;
                if (dimension >= 3) {
                    this.coords[offset + 2] = coordinates[i2].getOrdinate(2);
                }
                if (dimension < 4) continue;
                this.coords[offset + 3] = coordinates[i2].getOrdinate(3);
            }
        }

        public Double(Coordinate[] coordinates) {
            this(coordinates, 3, 0);
        }

        public Double(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coords = new double[size * this.dimension];
        }

        @Override
        public Coordinate getCoordinateInternal(int i2) {
            double x = this.coords[i2 * this.dimension];
            double y = this.coords[i2 * this.dimension + 1];
            if (this.dimension == 2 && this.measures == 0) {
                return new CoordinateXY(x, y);
            }
            if (this.dimension == 3 && this.measures == 0) {
                double z = this.coords[i2 * this.dimension + 2];
                return new Coordinate(x, y, z);
            }
            if (this.dimension == 3 && this.measures == 1) {
                double m = this.coords[i2 * this.dimension + 2];
                return new CoordinateXYM(x, y, m);
            }
            if (this.dimension == 4) {
                double z = this.coords[i2 * this.dimension + 2];
                double m = this.coords[i2 * this.dimension + 3];
                return new CoordinateXYZM(x, y, z, m);
            }
            return new Coordinate(x, y);
        }

        public double[] getRawCoordinates() {
            return this.coords;
        }

        @Override
        public int size() {
            return this.coords.length / this.dimension;
        }

        @Override
        public Object clone() {
            return this.copy();
        }

        @Override
        public Double copy() {
            double[] clone = Arrays.copyOf(this.coords, this.coords.length);
            return new Double(clone, this.dimension, this.measures);
        }

        @Override
        public double getOrdinate(int index2, int ordinate) {
            return this.coords[index2 * this.dimension + ordinate];
        }

        @Override
        public void setOrdinate(int index2, int ordinate, double value2) {
            this.coordRef = null;
            this.coords[index2 * this.dimension + ordinate] = value2;
        }

        @Override
        public Envelope expandEnvelope(Envelope env) {
            for (int i2 = 0; i2 < this.coords.length; i2 += this.dimension) {
                if (i2 + 1 >= this.coords.length) continue;
                env.expandToInclude(this.coords[i2], this.coords[i2 + 1]);
            }
            return env;
        }
    }
}

