/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.util.GeometryCollectionMapper;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.locationtech.jts.operation.union.UnaryUnionOp;

class GeometryOverlay {
    public static String OVERLAY_PROPERTY_NAME = "jts.overlay";
    public static String OVERLAY_PROPERTY_VALUE_NG = "ng";
    public static String OVERLAY_PROPERTY_VALUE_OLD = "old";
    public static boolean OVERLAY_NG_DEFAULT;
    private static boolean isOverlayNG;

    GeometryOverlay() {
    }

    static void setOverlayImpl(String overlayImplCode) {
        if (overlayImplCode == null) {
            return;
        }
        isOverlayNG = OVERLAY_NG_DEFAULT;
        if (OVERLAY_PROPERTY_VALUE_NG.equalsIgnoreCase(overlayImplCode)) {
            isOverlayNG = true;
        }
    }

    private static Geometry overlay(Geometry a, Geometry b2, int opCode) {
        if (isOverlayNG) {
            return OverlayNGRobust.overlay(a, b2, opCode);
        }
        return SnapIfNeededOverlayOp.overlayOp(a, b2, opCode);
    }

    static Geometry difference(Geometry a, Geometry b2) {
        if (a.isEmpty()) {
            return OverlayOp.createEmptyResult(3, a, b2, a.getFactory());
        }
        if (b2.isEmpty()) {
            return a.copy();
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b2);
        return GeometryOverlay.overlay(a, b2, 3);
    }

    static Geometry intersection(Geometry a, Geometry b2) {
        if (a.isEmpty() || b2.isEmpty()) {
            return OverlayOp.createEmptyResult(1, a, b2, a.getFactory());
        }
        if (a.isGeometryCollection()) {
            final Geometry g2 = b2;
            return GeometryCollectionMapper.map((GeometryCollection)a, new GeometryMapper.MapOp(){

                @Override
                public Geometry map(Geometry g22) {
                    return g22.intersection(g2);
                }
            });
        }
        return GeometryOverlay.overlay(a, b2, 1);
    }

    static Geometry symDifference(Geometry a, Geometry b2) {
        if (a.isEmpty() || b2.isEmpty()) {
            if (a.isEmpty() && b2.isEmpty()) {
                return OverlayOp.createEmptyResult(4, a, b2, a.getFactory());
            }
            if (a.isEmpty()) {
                return b2.copy();
            }
            if (b2.isEmpty()) {
                return a.copy();
            }
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b2);
        return GeometryOverlay.overlay(a, b2, 4);
    }

    static Geometry union(Geometry a, Geometry b2) {
        if (a.isEmpty() || b2.isEmpty()) {
            if (a.isEmpty() && b2.isEmpty()) {
                return OverlayOp.createEmptyResult(2, a, b2, a.getFactory());
            }
            if (a.isEmpty()) {
                return b2.copy();
            }
            if (b2.isEmpty()) {
                return a.copy();
            }
        }
        Geometry.checkNotGeometryCollection(a);
        Geometry.checkNotGeometryCollection(b2);
        return GeometryOverlay.overlay(a, b2, 2);
    }

    static Geometry union(Geometry a) {
        if (isOverlayNG) {
            return OverlayNGRobust.union(a);
        }
        return UnaryUnionOp.union(a);
    }

    static {
        isOverlayNG = OVERLAY_NG_DEFAULT = false;
        GeometryOverlay.setOverlayImpl(System.getProperty(OVERLAY_PROPERTY_NAME));
    }
}

