/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

public class GeometryCollectionIterator
implements Iterator {
    private Geometry parent;
    private boolean atStart;
    private int max;
    private int index;
    private GeometryCollectionIterator subcollectionIterator;

    public GeometryCollectionIterator(Geometry parent2) {
        this.parent = parent2;
        this.atStart = true;
        this.index = 0;
        this.max = parent2.getNumGeometries();
    }

    @Override
    public boolean hasNext() {
        if (this.atStart) {
            return true;
        }
        if (this.subcollectionIterator != null) {
            if (this.subcollectionIterator.hasNext()) {
                return true;
            }
            this.subcollectionIterator = null;
        }
        return this.index < this.max;
    }

    public Object next() {
        Geometry obj2;
        if (this.atStart) {
            this.atStart = false;
            if (GeometryCollectionIterator.isAtomic(this.parent)) {
                ++this.index;
            }
            return this.parent;
        }
        if (this.subcollectionIterator != null) {
            if (this.subcollectionIterator.hasNext()) {
                return this.subcollectionIterator.next();
            }
            this.subcollectionIterator = null;
        }
        if (this.index >= this.max) {
            throw new NoSuchElementException();
        }
        if ((obj2 = this.parent.getGeometryN(this.index++)) instanceof GeometryCollection) {
            this.subcollectionIterator = new GeometryCollectionIterator((GeometryCollection)obj2);
            return this.subcollectionIterator.next();
        }
        return obj2;
    }

    private static boolean isAtomic(Geometry geom) {
        return !(geom instanceof GeometryCollection);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }
}

