/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Arrays;
import java.util.TreeSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.util.Assert;

public class GeometryCollection
extends Geometry {
    private static final long serialVersionUID = -5694727726395021467L;
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometries, PrecisionModel precisionModel, int SRID) {
        this(geometries, new GeometryFactory(precisionModel, SRID));
    }

    public GeometryCollection(Geometry[] geometries, GeometryFactory factory) {
        super(factory);
        if (geometries == null) {
            geometries = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometries)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometries;
    }

    @Override
    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    @Override
    public Coordinate[] getCoordinates() {
        Coordinate[] coordinates = new Coordinate[this.getNumPoints()];
        int k = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            Coordinate[] childCoordinates = this.geometries[i2].getCoordinates();
            for (int j = 0; j < childCoordinates.length; ++j) {
                coordinates[++k] = childCoordinates[j];
            }
        }
        return coordinates;
    }

    @Override
    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            if (this.geometries[i2].isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getDimension() {
        int dimension = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            dimension = Math.max(dimension, this.geometries[i2].getDimension());
        }
        return dimension;
    }

    @Override
    public int getBoundaryDimension() {
        int dimension = -1;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            dimension = Math.max(dimension, this.geometries[i2].getBoundaryDimension());
        }
        return dimension;
    }

    @Override
    public int getNumGeometries() {
        return this.geometries.length;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    @Override
    public int getNumPoints() {
        int numPoints = 0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            numPoints += this.geometries[i2].getNumPoints();
        }
        return numPoints;
    }

    @Override
    public String getGeometryType() {
        return "GeometryCollection";
    }

    @Override
    public Geometry getBoundary() {
        GeometryCollection.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    @Override
    public double getArea() {
        double area = 0.0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            area += this.geometries[i2].getArea();
        }
        return area;
    }

    @Override
    public double getLength() {
        double sum2 = 0.0;
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            sum2 += this.geometries[i2].getLength();
        }
        return sum2;
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (!this.isEquivalentClass(other)) {
            return false;
        }
        GeometryCollection otherCollection = (GeometryCollection)other;
        if (this.geometries.length != otherCollection.geometries.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            if (this.geometries[i2].equalsExact(otherCollection.geometries[i2], tolerance)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(CoordinateFilter filter2) {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter2);
        }
    }

    @Override
    public void apply(CoordinateSequenceFilter filter2) {
        if (this.geometries.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter2);
            if (filter2.isDone()) break;
        }
        if (filter2.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    @Override
    public void apply(GeometryFilter filter2) {
        filter2.filter(this);
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter2);
        }
    }

    @Override
    public void apply(GeometryComponentFilter filter2) {
        filter2.filter(this);
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].apply(filter2);
        }
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    protected GeometryCollection copyInternal() {
        Geometry[] geometries = new Geometry[this.geometries.length];
        for (int i2 = 0; i2 < geometries.length; ++i2) {
            geometries[i2] = this.geometries[i2].copy();
        }
        return new GeometryCollection(geometries, this.factory);
    }

    @Override
    public void normalize() {
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            this.geometries[i2].normalize();
        }
        Arrays.sort(this.geometries);
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        for (int i2 = 0; i2 < this.geometries.length; ++i2) {
            envelope.expandToInclude(this.geometries[i2].getEnvelopeInternal());
        }
        return envelope;
    }

    @Override
    protected int compareToSameClass(Object o2) {
        TreeSet<Geometry> theseElements = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> otherElements = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)o2).geometries));
        return this.compare(theseElements, otherElements);
    }

    @Override
    protected int compareToSameClass(Object o2, CoordinateSequenceComparator comp) {
        int i2;
        GeometryCollection gc = (GeometryCollection)o2;
        int n12 = this.getNumGeometries();
        int n22 = gc.getNumGeometries();
        for (i2 = 0; i2 < n12 && i2 < n22; ++i2) {
            Geometry otherGeom;
            Geometry thisGeom = this.getGeometryN(i2);
            int holeComp = thisGeom.compareToSameClass(otherGeom = gc.getGeometryN(i2), comp);
            if (holeComp == 0) continue;
            return holeComp;
        }
        if (i2 < n12) {
            return 1;
        }
        if (i2 < n22) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int getTypeCode() {
        return 7;
    }

    @Override
    public GeometryCollection reverse() {
        return (GeometryCollection)super.reverse();
    }

    @Override
    protected GeometryCollection reverseInternal() {
        Geometry[] geometries = new Geometry[this.geometries.length];
        for (int i2 = 0; i2 < geometries.length; ++i2) {
            geometries[i2] = this.geometries[i2].reverse();
        }
        return new GeometryCollection(geometries, this.factory);
    }
}

