/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.io.OrdinateFormat;

public class CoordinateSequences {
    public static void reverse(CoordinateSequence seq) {
        if (seq.size() <= 1) {
            return;
        }
        int last2 = seq.size() - 1;
        int mid = last2 / 2;
        for (int i2 = 0; i2 <= mid; ++i2) {
            CoordinateSequences.swap(seq, i2, last2 - i2);
        }
    }

    public static void swap(CoordinateSequence seq, int i2, int j) {
        if (i2 == j) {
            return;
        }
        for (int dim = 0; dim < seq.getDimension(); ++dim) {
            double tmp = seq.getOrdinate(i2, dim);
            seq.setOrdinate(i2, dim, seq.getOrdinate(j, dim));
            seq.setOrdinate(j, dim, tmp);
        }
    }

    public static void copy(CoordinateSequence src2, int srcPos, CoordinateSequence dest, int destPos, int length) {
        for (int i2 = 0; i2 < length; ++i2) {
            CoordinateSequences.copyCoord(src2, srcPos + i2, dest, destPos + i2);
        }
    }

    public static void copyCoord(CoordinateSequence src2, int srcPos, CoordinateSequence dest, int destPos) {
        int minDim = Math.min(src2.getDimension(), dest.getDimension());
        for (int dim = 0; dim < minDim; ++dim) {
            dest.setOrdinate(destPos, dim, src2.getOrdinate(srcPos, dim));
        }
    }

    public static boolean isRing(CoordinateSequence seq) {
        int n = seq.size();
        if (n == 0) {
            return true;
        }
        if (n <= 3) {
            return false;
        }
        return seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
    }

    public static CoordinateSequence ensureValidRing(CoordinateSequenceFactory fact, CoordinateSequence seq) {
        boolean isClosed;
        int n = seq.size();
        if (n == 0) {
            return seq;
        }
        if (n <= 3) {
            return CoordinateSequences.createClosedRing(fact, seq, 4);
        }
        boolean bl = isClosed = seq.getOrdinate(0, 0) == seq.getOrdinate(n - 1, 0) && seq.getOrdinate(0, 1) == seq.getOrdinate(n - 1, 1);
        if (isClosed) {
            return seq;
        }
        return CoordinateSequences.createClosedRing(fact, seq, n + 1);
    }

    private static CoordinateSequence createClosedRing(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        for (int i2 = n; i2 < size; ++i2) {
            CoordinateSequences.copy(seq, 0, newseq, i2, 1);
        }
        return newseq;
    }

    public static CoordinateSequence extend(CoordinateSequenceFactory fact, CoordinateSequence seq, int size) {
        CoordinateSequence newseq = fact.create(size, seq.getDimension());
        int n = seq.size();
        CoordinateSequences.copy(seq, 0, newseq, 0, n);
        if (n > 0) {
            for (int i2 = n; i2 < size; ++i2) {
                CoordinateSequences.copy(seq, n - 1, newseq, i2, 1);
            }
        }
        return newseq;
    }

    public static boolean isEqual(CoordinateSequence cs1, CoordinateSequence cs2) {
        int cs2Size;
        int cs1Size = cs1.size();
        if (cs1Size != (cs2Size = cs2.size())) {
            return false;
        }
        int dim = Math.min(cs1.getDimension(), cs2.getDimension());
        for (int i2 = 0; i2 < cs1Size; ++i2) {
            for (int d2 = 0; d2 < dim; ++d2) {
                double v1 = cs1.getOrdinate(i2, d2);
                double v2 = cs2.getOrdinate(i2, d2);
                if (cs1.getOrdinate(i2, d2) == cs2.getOrdinate(i2, d2) || Double.isNaN(v1) && Double.isNaN(v2)) continue;
                return false;
            }
        }
        return true;
    }

    public static String toString(CoordinateSequence cs) {
        int size = cs.size();
        if (size == 0) {
            return "()";
        }
        int dim = cs.getDimension();
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 > 0) {
                builder.append(" ");
            }
            for (int d2 = 0; d2 < dim; ++d2) {
                if (d2 > 0) {
                    builder.append(",");
                }
                builder.append(OrdinateFormat.DEFAULT.format(cs.getOrdinate(i2, d2)));
            }
        }
        builder.append(')');
        return builder.toString();
    }

    public static Coordinate minCoordinate(CoordinateSequence seq) {
        Coordinate minCoord = null;
        for (int i2 = 0; i2 < seq.size(); ++i2) {
            Coordinate testCoord = seq.getCoordinate(i2);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
        }
        return minCoord;
    }

    public static int minCoordinateIndex(CoordinateSequence seq) {
        return CoordinateSequences.minCoordinateIndex(seq, 0, seq.size() - 1);
    }

    public static int minCoordinateIndex(CoordinateSequence seq, int from, int to) {
        int minCoordIndex = -1;
        Coordinate minCoord = null;
        for (int i2 = from; i2 <= to; ++i2) {
            Coordinate testCoord = seq.getCoordinate(i2);
            if (minCoord != null && minCoord.compareTo(testCoord) <= 0) continue;
            minCoord = testCoord;
            minCoordIndex = i2;
        }
        return minCoordIndex;
    }

    public static void scroll(CoordinateSequence seq, Coordinate firstCoordinate) {
        int i2 = CoordinateSequences.indexOf(firstCoordinate, seq);
        if (i2 <= 0) {
            return;
        }
        CoordinateSequences.scroll(seq, i2);
    }

    public static void scroll(CoordinateSequence seq, int indexOfFirstCoordinate) {
        CoordinateSequences.scroll(seq, indexOfFirstCoordinate, CoordinateSequences.isRing(seq));
    }

    public static void scroll(CoordinateSequence seq, int indexOfFirstCoordinate, boolean ensureRing) {
        int i2 = indexOfFirstCoordinate;
        if (i2 <= 0) {
            return;
        }
        CoordinateSequence copy = seq.copy();
        int last2 = ensureRing ? seq.size() - 1 : seq.size();
        for (int j = 0; j < last2; ++j) {
            for (int k = 0; k < seq.getDimension(); ++k) {
                seq.setOrdinate(j, k, copy.getOrdinate((indexOfFirstCoordinate + j) % last2, k));
            }
        }
        if (ensureRing) {
            for (int k = 0; k < seq.getDimension(); ++k) {
                seq.setOrdinate(last2, k, seq.getOrdinate(0, k));
            }
        }
    }

    public static int indexOf(Coordinate coordinate, CoordinateSequence seq) {
        for (int i2 = 0; i2 < seq.size(); ++i2) {
            if (coordinate.x != seq.getOrdinate(i2, 0) || coordinate.y != seq.getOrdinate(i2, 1)) continue;
            return i2;
        }
        return -1;
    }
}

