/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.densify;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class Densifier {
    private Geometry inputGeom;
    private double distanceTolerance;
    private boolean isValidated = true;

    public static Geometry densify(Geometry geom, double distanceTolerance) {
        Densifier densifier = new Densifier(geom);
        densifier.setDistanceTolerance(distanceTolerance);
        return densifier.getResultGeometry();
    }

    private static Coordinate[] densifyPoints(Coordinate[] pts, double distanceTolerance, PrecisionModel precModel) {
        LineSegment seg = new LineSegment();
        CoordinateList coordList = new CoordinateList();
        for (int i2 = 0; i2 < pts.length - 1; ++i2) {
            seg.p0 = pts[i2];
            seg.p1 = pts[i2 + 1];
            coordList.add(seg.p0, false);
            double len = seg.getLength();
            if (len <= distanceTolerance) continue;
            int densifiedSegCount = (int)Math.ceil(len / distanceTolerance);
            double densifiedSegLen = len / (double)densifiedSegCount;
            for (int j = 1; j < densifiedSegCount; ++j) {
                double segFract = (double)j * densifiedSegLen / len;
                Coordinate p2 = seg.pointAlong(segFract);
                if (!Double.isNaN(seg.p0.z) && !Double.isNaN(seg.p1.z)) {
                    p2.setZ(seg.p0.z + segFract * (seg.p1.z - seg.p0.z));
                }
                precModel.makePrecise(p2);
                coordList.add(p2, false);
            }
        }
        if (pts.length > 0) {
            coordList.add(pts[pts.length - 1], false);
        }
        return coordList.toCoordinateArray();
    }

    public Densifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public void setValidate(boolean isValidated) {
        this.isValidated = isValidated;
    }

    public Geometry getResultGeometry() {
        return new DensifyTransformer(this.distanceTolerance, this.isValidated).transform(this.inputGeom);
    }

    static class DensifyTransformer
    extends GeometryTransformer {
        double distanceTolerance;
        private boolean isValidated;

        DensifyTransformer(double distanceTolerance, boolean isValidated) {
            this.distanceTolerance = distanceTolerance;
            this.isValidated = isValidated;
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent2) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = Densifier.densifyPoints(inputPts, this.distanceTolerance, parent2.getPrecisionModel());
            if (parent2 instanceof LineString && newPts.length == 1) {
                newPts = new Coordinate[]{};
            }
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        @Override
        protected Geometry transformPolygon(Polygon geom, Geometry parent2) {
            Geometry roughGeom = super.transformPolygon(geom, parent2);
            if (parent2 instanceof MultiPolygon) {
                return roughGeom;
            }
            return this.createValidArea(roughGeom);
        }

        @Override
        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent2) {
            Geometry roughGeom = super.transformMultiPolygon(geom, parent2);
            return this.createValidArea(roughGeom);
        }

        private Geometry createValidArea(Geometry roughAreaGeom) {
            if (!this.isValidated || roughAreaGeom.isValid()) {
                return roughAreaGeom;
            }
            return roughAreaGeom.buffer(0.0);
        }
    }
}

