/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm.distance;

import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;

public class DistanceToPoint {
    public static void computeDistance(Geometry geom, Coordinate pt, PointPairDistance ptDist) {
        if (geom instanceof LineString) {
            DistanceToPoint.computeDistance((LineString)geom, pt, ptDist);
        } else if (geom instanceof Polygon) {
            DistanceToPoint.computeDistance((Polygon)geom, pt, ptDist);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
                Geometry g2 = gc.getGeometryN(i2);
                DistanceToPoint.computeDistance(g2, pt, ptDist);
            }
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt);
        }
    }

    public static void computeDistance(LineString line, Coordinate pt, PointPairDistance ptDist) {
        LineSegment tempSegment = new LineSegment();
        Coordinate[] coords = line.getCoordinates();
        for (int i2 = 0; i2 < coords.length - 1; ++i2) {
            tempSegment.setCoordinates(coords[i2], coords[i2 + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public static void computeDistance(LineSegment segment, Coordinate pt, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    public static void computeDistance(Polygon poly, Coordinate pt, PointPairDistance ptDist) {
        DistanceToPoint.computeDistance(poly.getExteriorRing(), pt, ptDist);
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            DistanceToPoint.computeDistance(poly.getInteriorRingN(i2), pt, ptDist);
        }
    }
}

