/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeConverter;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.sisu.Parameters;
import org.eclipse.sisu.inject.BeanLocator;
import org.eclipse.sisu.wire.BeanProviders;
import org.eclipse.sisu.wire.TypeConverterCache;

final class PlaceholderBeanProvider<V>
implements Provider<V> {
    private static final int EXPRESSION_RECURSION_LIMIT = 8;
    @Inject
    @Parameters
    private Map properties;
    @Inject
    private TypeConverterCache converterCache;
    private final Provider<BeanLocator> locator;
    private final Key<V> placeholderKey;

    PlaceholderBeanProvider(Provider<BeanLocator> locator, Key<V> key2) {
        this.locator = locator;
        this.placeholderKey = key2;
    }

    public V get() {
        Object bean;
        TypeLiteral expectedType;
        Class clazz;
        String template = ((Named)this.placeholderKey.getAnnotation()).value();
        Object value2 = this.interpolate(template, clazz = (expectedType = this.placeholderKey.getTypeLiteral()).getRawType());
        if (!(value2 instanceof String)) {
            return (V)value2;
        }
        Key lookupKey = Key.get((TypeLiteral)expectedType, (Annotation)Names.named((String)((String)value2)));
        if (String.class != clazz && (bean = this.lookup(lookupKey)) != null) {
            return (V)bean;
        }
        if (template == value2) {
            value2 = PlaceholderBeanProvider.nullify((String)this.lookup(lookupKey.ofType(String.class)));
        }
        if (value2 == null || String.class == clazz) {
            return (V)value2;
        }
        TypeConverter converter = this.converterCache.getTypeConverter(expectedType);
        if (converter != null) {
            return (V)converter.convert((String)value2, expectedType);
        }
        return null;
    }

    private <T> T lookup(Key<T> key2) {
        return BeanProviders.firstOf(((BeanLocator)this.locator.get()).locate(key2));
    }

    private static String nullify(String value2) {
        return "null".equals(value2) ? null : value2;
    }

    private Object interpolate(String template, Class<?> clazz) {
        int y;
        StringBuilder buf;
        if (template.contains("${")) {
            buf = new StringBuilder(template);
        } else if (this.properties.containsKey(template)) {
            buf = new StringBuilder("${").append(template).append('}');
        } else {
            return template;
        }
        int x = 0;
        int expressionEnd = 0;
        int expressionNum = 0;
        while ((x = buf.indexOf("${", x)) >= 0 && (y = buf.indexOf("}", x) + 1) > 0) {
            String key2;
            int anchor2;
            Object value2;
            if (y > expressionEnd) {
                expressionNum = 0;
                expressionEnd = y;
            }
            if ((value2 = this.properties.get((anchor2 = (key2 = buf.substring(x + 2, y - 1)).indexOf(":-")) < 0 ? key2 : key2.substring(0, anchor2))) == null && anchor2 >= 0) {
                value2 = key2.substring(anchor2 + 2);
            }
            if (expressionNum++ >= 8) {
                throw new ProvisionException("Recursive configuration: " + template + " stopped at: " + buf);
            }
            int len = buf.length();
            if (x == 0 && len == y && String.class != clazz && clazz.isInstance(value2)) {
                return value2;
            }
            buf.replace(x, y, String.valueOf(value2));
            expressionEnd += buf.length() - len;
        }
        return PlaceholderBeanProvider.nullify(buf.toString());
    }
}

