/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.inject.Provider;
import javax.inject.Qualifier;

final class WildcardKey {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);

    private WildcardKey() {
    }

    public static Key<Object> get(Class<?> type2, Annotation qualifier) {
        return Key.get(OBJECT_TYPE_LITERAL, (Annotation)new QualifiedImpl(type2, qualifier));
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Qualified {
        public Class<?> value();
    }

    private static final class QualifiedImpl
    implements Qualified,
    Provider<Annotation> {
        private final Class<?> value;
        private final Annotation qualifier;

        QualifiedImpl(Class<?> value2, Annotation qualifier) {
            this.value = value2;
            this.qualifier = qualifier;
        }

        @Override
        public Class<?> value() {
            return this.value;
        }

        public Annotation get() {
            return this.qualifier;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Qualified.class;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object rhs) {
            if (this == rhs) {
                return true;
            }
            if (rhs instanceof QualifiedImpl) {
                return this.value == ((QualifiedImpl)rhs).value;
            }
            return false;
        }

        @Override
        public String toString() {
            return "*";
        }
    }
}

