/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import com.google.inject.Module;
import java.net.URL;
import javax.inject.Qualifier;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.AnnotationVisitor;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.ClassVisitor;
import org.eclipse.sisu.space.QualifiedTypeListener;
import org.eclipse.sisu.space.QualifierCache;
import org.eclipse.sisu.space.SpaceVisitor;

public final class QualifiedTypeVisitor
implements SpaceVisitor,
ClassVisitor {
    private final QualifierCache qualifierCache = new QualifierCache();
    private final QualifiedTypeListener listener;
    private ClassSpace space;
    private URL location;
    private String source;
    private String clazzName;
    private boolean qualified;

    public QualifiedTypeVisitor(QualifiedTypeListener listener2) {
        this.listener = listener2;
    }

    public static boolean verify(ClassSpace space, Class<?> ... specification) {
        Class<?>[] classArray = specification;
        int n = specification.length;
        int n3 = 0;
        while (n3 < n) {
            block4: {
                Class<?> expectedClazz = classArray[n3];
                try {
                    Class<?> spaceClazz = space.loadClass(expectedClazz.getName());
                    if (spaceClazz != expectedClazz) {
                        Logs.warn("Inconsistent ClassLoader for: {} in: {}", expectedClazz, space);
                        Logs.warn("Expected: {} saw: {}", expectedClazz.getClassLoader(), spaceClazz.getClassLoader());
                    }
                }
                catch (TypeNotPresentException typeNotPresentException) {
                    if (!expectedClazz.isAnnotation()) break block4;
                    Logs.trace("Potential problem: {} is not visible from: {}", expectedClazz, space);
                }
            }
            ++n3;
        }
        return true;
    }

    @Override
    public void enterSpace(ClassSpace _space) {
        this.space = _space;
        this.source = null;
        if (Logs.TRACE_ENABLED) {
            QualifiedTypeVisitor.verify(_space, Qualifier.class, Module.class);
        }
    }

    @Override
    public ClassVisitor visitClass(URL url) {
        this.location = url;
        this.clazzName = null;
        this.qualified = false;
        return this;
    }

    @Override
    public void enterClass(int modifiers, String name2, String _extends, String[] _implements) {
        if ((modifiers & 0x7600) == 0) {
            this.clazzName = name2;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc) {
        if (this.clazzName != null) {
            this.qualified = this.qualified || this.qualifierCache.qualify(this.space, desc);
        }
        return null;
    }

    public void disqualify() {
        this.qualified = false;
    }

    @Override
    public void leaveClass() {
        if (this.qualified) {
            this.listener.hear(this.space.loadClass(this.clazzName.replace('/', '.')), this.findSource());
        }
    }

    @Override
    public void leaveSpace() {
    }

    private String findSource() {
        if (this.location != null) {
            String path = this.location.getPath();
            if (this.source == null || !path.startsWith(this.source)) {
                int i2 = path.indexOf(this.clazzName);
                this.source = i2 <= 0 ? path : path.substring(0, i2);
            }
        } else if (this.source == null) {
            this.source = this.space.toString();
        }
        return this.source;
    }
}

