/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.ImplementedBy;
import com.google.inject.Key;
import com.google.inject.ProvidedBy;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.inject.Qualifier;

public final class TypeArguments {
    private static final TypeLiteral<Object> OBJECT_TYPE_LITERAL = TypeLiteral.get(Object.class);
    private static final TypeLiteral<?>[] NO_TYPE_LITERALS = new TypeLiteral[0];

    private TypeArguments() {
    }

    public static TypeLiteral<?>[] get(TypeLiteral<?> typeLiteral) {
        Type type2 = typeLiteral.getType();
        if (type2 instanceof ParameterizedType) {
            Type[] argumentTypes = ((ParameterizedType)type2).getActualTypeArguments();
            TypeLiteral[] argumentLiterals = new TypeLiteral[argumentTypes.length];
            int i2 = 0;
            while (i2 < argumentTypes.length) {
                argumentLiterals[i2] = TypeArguments.expand(argumentTypes[i2]);
                ++i2;
            }
            return argumentLiterals;
        }
        if (type2 instanceof GenericArrayType) {
            return new TypeLiteral[]{TypeArguments.expand(((GenericArrayType)type2).getGenericComponentType())};
        }
        return NO_TYPE_LITERALS;
    }

    public static TypeLiteral<?> get(TypeLiteral<?> typeLiteral, int index2) {
        Type type2 = typeLiteral.getType();
        if (type2 instanceof ParameterizedType) {
            return TypeArguments.expand(((ParameterizedType)type2).getActualTypeArguments()[index2]);
        }
        if (type2 instanceof GenericArrayType) {
            if (index2 == 0) {
                return TypeArguments.expand(((GenericArrayType)type2).getGenericComponentType());
            }
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        return OBJECT_TYPE_LITERAL;
    }

    public static boolean isAssignableFrom(TypeLiteral<?> superLiteral, TypeLiteral<?> subLiteral) {
        Type resolvedType;
        Class superClazz = superLiteral.getRawType();
        if (!superClazz.isAssignableFrom(subLiteral.getRawType())) {
            return false;
        }
        Type superType = superLiteral.getType();
        if (superClazz == superType) {
            return true;
        }
        if (superType instanceof ParameterizedType) {
            Type resolvedType2 = subLiteral.getSupertype(superClazz).getType();
            if (resolvedType2 instanceof ParameterizedType) {
                Type[] superArgs = ((ParameterizedType)superType).getActualTypeArguments();
                Type[] subArgs = ((ParameterizedType)resolvedType2).getActualTypeArguments();
                return TypeArguments.isAssignableFrom(superArgs, subArgs);
            }
        } else if (superType instanceof GenericArrayType && (resolvedType = subLiteral.getSupertype(superClazz).getType()) instanceof GenericArrayType) {
            Type superComponent = ((GenericArrayType)superType).getGenericComponentType();
            Type subComponent = ((GenericArrayType)resolvedType).getGenericComponentType();
            return TypeArguments.isAssignableFrom(new Type[]{superComponent}, new Type[]{subComponent});
        }
        return false;
    }

    public static boolean isConcrete(TypeLiteral<?> literal) {
        return TypeArguments.isConcrete(literal.getRawType());
    }

    public static boolean isConcrete(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isImplicit(TypeLiteral<?> literal) {
        return TypeArguments.isImplicit(literal.getRawType());
    }

    public static boolean isImplicit(Class<?> clazz) {
        return TypeArguments.isConcrete(clazz) || clazz.isAnnotationPresent(ImplementedBy.class) || clazz.isAnnotationPresent(ProvidedBy.class);
    }

    public static <T> Key<T> implicitKey(Class<T> clazz) {
        return Key.get(clazz, Implicit.class);
    }

    private static TypeLiteral<?> expand(Type type2) {
        if (type2 instanceof WildcardType) {
            return TypeLiteral.get((Type)((WildcardType)type2).getUpperBounds()[0]);
        }
        if (type2 instanceof TypeVariable) {
            return TypeLiteral.get((Type)((TypeVariable)type2).getBounds()[0]);
        }
        return TypeLiteral.get((Type)type2);
    }

    private static boolean isAssignableFrom(Type[] superArgs, Type[] subArgs) {
        int i2 = 0;
        int len = Math.min(superArgs.length, subArgs.length);
        while (i2 < len) {
            Type superType = superArgs[i2];
            Type subType = subArgs[i2];
            if (!(subType instanceof TypeVariable && TypeArguments.isAssignableFrom(TypeArguments.expand(subType), TypeArguments.expand(superType)) || !(superType instanceof WildcardType || superType instanceof TypeVariable ? !TypeArguments.isAssignableFrom(TypeArguments.expand(superType), TypeArguments.expand(subType)) : !superType.equals(subType)))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Implicit {
    }
}

