/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.Objects;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;

final class GenericVersionRange
implements VersionRange {
    private final VersionRange.Bound lowerBound;
    private final VersionRange.Bound upperBound;

    GenericVersionRange(String range) throws InvalidVersionSpecificationException {
        Version upperBound;
        Version lowerBound;
        boolean upperBoundInclusive;
        boolean lowerBoundInclusive;
        String process2 = range;
        if (range.startsWith("[")) {
            lowerBoundInclusive = true;
        } else if (range.startsWith("(")) {
            lowerBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", a range must start with either [ or (");
        }
        if (range.endsWith("]")) {
            upperBoundInclusive = true;
        } else if (range.endsWith(")")) {
            upperBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", a range must end with either [ or (");
        }
        process2 = process2.substring(1, process2.length() - 1);
        int index2 = process2.indexOf(",");
        if (index2 < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", single version must be surrounded by []");
            }
            String version = process2.trim();
            if (version.endsWith(".*")) {
                String prefix = version.substring(0, version.length() - 1);
                lowerBound = this.parse(prefix + "min");
                upperBound = this.parse(prefix + "max");
            } else {
                upperBound = lowerBound = this.parse(version);
            }
        } else {
            String parsedLowerBound = process2.substring(0, index2).trim();
            String parsedUpperBound = process2.substring(index2 + 1).trim();
            if (parsedUpperBound.contains(",")) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", bounds may not contain additional ','");
            }
            lowerBound = parsedLowerBound.length() > 0 ? this.parse(parsedLowerBound) : null;
            Version version = upperBound = parsedUpperBound.length() > 0 ? this.parse(parsedUpperBound) : null;
            if (upperBound != null && lowerBound != null && upperBound.compareTo(lowerBound) < 0) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", lower bound must not be greater than upper bound");
            }
        }
        this.lowerBound = lowerBound != null ? new VersionRange.Bound(lowerBound, lowerBoundInclusive) : null;
        this.upperBound = upperBound != null ? new VersionRange.Bound(upperBound, upperBoundInclusive) : null;
    }

    private Version parse(String version) {
        return new GenericVersion(version);
    }

    @Override
    public VersionRange.Bound getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public VersionRange.Bound getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean containsVersion(Version version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.lowerBound.isInclusive()) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.upperBound.isInclusive()) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        GenericVersionRange that = (GenericVersionRange)obj2;
        return Objects.equals(this.upperBound, that.upperBound) && Objects.equals(this.lowerBound, that.lowerBound);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + GenericVersionRange.hash(this.upperBound);
        hash = hash * 31 + GenericVersionRange.hash(this.lowerBound);
        return hash;
    }

    private static int hash(Object obj2) {
        return obj2 != null ? obj2.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        if (this.lowerBound != null) {
            buffer.append(this.lowerBound.isInclusive() ? (char)'[' : '(');
            buffer.append(this.lowerBound.getVersion());
        } else {
            buffer.append('(');
        }
        buffer.append(',');
        if (this.upperBound != null) {
            buffer.append(this.upperBound.getVersion());
            buffer.append(this.upperBound.isInclusive() ? (char)']' : ')');
        } else {
            buffer.append(')');
        }
        return buffer.toString();
    }
}

