/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.graph.version;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.VersionFilter;

public final class ChainedVersionFilter
implements VersionFilter {
    private final VersionFilter[] filters;
    private int hashCode;

    public static VersionFilter newInstance(VersionFilter filter1, VersionFilter filter2) {
        if (filter1 == null) {
            return filter2;
        }
        if (filter2 == null) {
            return filter1;
        }
        return new ChainedVersionFilter(new VersionFilter[]{filter1, filter2});
    }

    public static VersionFilter newInstance(VersionFilter ... filters) {
        if (filters.length <= 1) {
            if (filters.length <= 0) {
                return null;
            }
            return filters[0];
        }
        return new ChainedVersionFilter((VersionFilter[])filters.clone());
    }

    public static VersionFilter newInstance(Collection<? extends VersionFilter> filters) {
        if (filters.size() <= 1) {
            if (filters.isEmpty()) {
                return null;
            }
            return filters.iterator().next();
        }
        return new ChainedVersionFilter(filters.toArray(new VersionFilter[filters.size()]));
    }

    private ChainedVersionFilter(VersionFilter[] filters) {
        this.filters = filters;
    }

    @Override
    public void filterVersions(VersionFilter.VersionFilterContext context) throws RepositoryException {
        int n = this.filters.length;
        for (int i2 = 0; i2 < n && context.getCount() > 0; ++i2) {
            this.filters[i2].filterVersions(context);
        }
    }

    @Override
    public VersionFilter deriveChildFilter(DependencyCollectionContext context) {
        VersionFilter[] children2 = null;
        int removed = 0;
        int n = this.filters.length;
        for (int i2 = 0; i2 < n; ++i2) {
            VersionFilter child = this.filters[i2].deriveChildFilter(context);
            if (children2 != null) {
                children2[i2 - removed] = child;
            } else if (child != this.filters[i2]) {
                children2 = new VersionFilter[this.filters.length];
                System.arraycopy(this.filters, 0, children2, 0, i2);
                children2[i2 - removed] = child;
            }
            if (child != null) continue;
            ++removed;
        }
        if (children2 == null) {
            return this;
        }
        if (removed > 0) {
            int count = this.filters.length - removed;
            if (count <= 0) {
                return null;
            }
            if (count == 1) {
                return children2[0];
            }
            VersionFilter[] tmp = new VersionFilter[count];
            System.arraycopy(children2, 0, tmp, 0, count);
            children2 = tmp;
        }
        return new ChainedVersionFilter(children2);
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (null == obj2 || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        ChainedVersionFilter that = (ChainedVersionFilter)obj2;
        return Arrays.equals(this.filters, that.filters);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = this.getClass().hashCode();
            this.hashCode = hash = hash * 31 + Arrays.hashCode(this.filters);
        }
        return this.hashCode;
    }
}

