/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

public final class OrDependencyFilter
implements DependencyFilter {
    private final Set<DependencyFilter> filters = new LinkedHashSet<DependencyFilter>();

    public OrDependencyFilter(DependencyFilter ... filters) {
        if (filters != null) {
            Collections.addAll(this.filters, filters);
        }
    }

    public OrDependencyFilter(Collection<DependencyFilter> filters) {
        if (filters != null) {
            this.filters.addAll(filters);
        }
    }

    public static DependencyFilter newInstance(DependencyFilter filter1, DependencyFilter filter2) {
        if (filter1 == null) {
            return filter2;
        }
        if (filter2 == null) {
            return filter1;
        }
        return new OrDependencyFilter(filter1, filter2);
    }

    @Override
    public boolean accept(DependencyNode node2, List<DependencyNode> parents2) {
        for (DependencyFilter filter2 : this.filters) {
            if (!filter2.accept(node2, parents2)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        OrDependencyFilter that = (OrDependencyFilter)obj2;
        return this.filters.equals(that.filters);
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + this.filters.hashCode();
        return hash;
    }
}

