/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;
import org.eclipse.aether.version.VersionScheme;

class AbstractPatternDependencyFilter
implements DependencyFilter {
    private final Set<String> patterns = new HashSet<String>();
    private final VersionScheme versionScheme;

    AbstractPatternDependencyFilter(String ... patterns2) {
        this((VersionScheme)null, patterns2);
    }

    AbstractPatternDependencyFilter(VersionScheme versionScheme, String ... patterns2) {
        this(versionScheme, patterns2 == null ? null : Arrays.asList(patterns2));
    }

    AbstractPatternDependencyFilter(Collection<String> patterns2) {
        this(null, patterns2);
    }

    AbstractPatternDependencyFilter(VersionScheme versionScheme, Collection<String> patterns2) {
        if (patterns2 != null) {
            this.patterns.addAll(patterns2);
        }
        this.versionScheme = versionScheme;
    }

    @Override
    public boolean accept(DependencyNode node2, List<DependencyNode> parents2) {
        Dependency dependency = node2.getDependency();
        if (dependency == null) {
            return true;
        }
        return this.accept(dependency.getArtifact());
    }

    protected boolean accept(Artifact artifact) {
        for (String pattern2 : this.patterns) {
            boolean matched = this.accept(artifact, pattern2);
            if (!matched) continue;
            return true;
        }
        return false;
    }

    private boolean accept(Artifact artifact, String pattern2) {
        String[] tokens = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getBaseVersion()};
        String[] patternTokens = pattern2.split(":");
        boolean matched = patternTokens.length <= tokens.length;
        for (int i2 = 0; matched && i2 < patternTokens.length; ++i2) {
            matched = this.matches(tokens[i2], patternTokens[i2]);
        }
        return matched;
    }

    private boolean matches(String token, String pattern2) {
        boolean matches2;
        if ("*".equals(pattern2) || pattern2.length() == 0) {
            matches2 = true;
        } else if (pattern2.startsWith("*") && pattern2.endsWith("*")) {
            String contains = pattern2.substring(1, pattern2.length() - 1);
            matches2 = token.contains(contains);
        } else if (pattern2.startsWith("*")) {
            String suffix2 = pattern2.substring(1);
            matches2 = token.endsWith(suffix2);
        } else if (pattern2.endsWith("*")) {
            String prefix = pattern2.substring(0, pattern2.length() - 1);
            matches2 = token.startsWith(prefix);
        } else {
            matches2 = pattern2.startsWith("[") || pattern2.startsWith("(") ? this.isVersionIncludedInRange(token, pattern2) : token.equals(pattern2);
        }
        return matches2;
    }

    private boolean isVersionIncludedInRange(String version, String range) {
        if (this.versionScheme == null) {
            return false;
        }
        try {
            Version parsedVersion = this.versionScheme.parseVersion(version);
            VersionRange parsedRange = this.versionScheme.parseVersionRange(range);
            return parsedRange.containsVersion(parsedVersion);
        }
        catch (InvalidVersionSpecificationException e2) {
            return false;
        }
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null || !this.getClass().equals(obj2.getClass())) {
            return false;
        }
        AbstractPatternDependencyFilter that = (AbstractPatternDependencyFilter)obj2;
        return Objects.equals(this.patterns, that.patterns) && Objects.equals(this.versionScheme, that.versionScheme);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.patterns.hashCode();
        hash = hash * 31 + (this.versionScheme == null ? 0 : this.versionScheme.hashCode());
        return hash;
    }
}

