/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.artifact;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.Artifact;

public final class SubArtifact
extends AbstractArtifact {
    private final Artifact mainArtifact;
    private final String classifier;
    private final String extension;
    private final File file;
    private final Map<String, String> properties;

    public SubArtifact(Artifact mainArtifact, String classifier, String extension) {
        this(mainArtifact, classifier, extension, (File)null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, File file) {
        this(mainArtifact, classifier, extension, null, file);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Map<String, String> properties2) {
        this(mainArtifact, classifier, extension, properties2, null);
    }

    public SubArtifact(Artifact mainArtifact, String classifier, String extension, Map<String, String> properties2, File file) {
        this.mainArtifact = Objects.requireNonNull(mainArtifact, "main artifact cannot be null");
        this.classifier = classifier;
        this.extension = extension;
        this.file = file;
        this.properties = SubArtifact.copyProperties(properties2);
    }

    private SubArtifact(Artifact mainArtifact, String classifier, String extension, File file, Map<String, String> properties2) {
        this.mainArtifact = mainArtifact;
        this.classifier = classifier;
        this.extension = extension;
        this.file = file;
        this.properties = properties2;
    }

    @Override
    public String getGroupId() {
        return this.mainArtifact.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.mainArtifact.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.mainArtifact.getVersion();
    }

    @Override
    public String getBaseVersion() {
        return this.mainArtifact.getBaseVersion();
    }

    @Override
    public boolean isSnapshot() {
        return this.mainArtifact.isSnapshot();
    }

    @Override
    public String getClassifier() {
        return SubArtifact.expand(this.classifier, this.mainArtifact.getClassifier());
    }

    @Override
    public String getExtension() {
        return SubArtifact.expand(this.extension, this.mainArtifact.getExtension());
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Artifact setFile(File file) {
        if (Objects.equals(this.file, file)) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, file, this.properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Artifact setProperties(Map<String, String> properties2) {
        if (this.properties.equals(properties2) || properties2 == null && this.properties.isEmpty()) {
            return this;
        }
        return new SubArtifact(this.mainArtifact, this.classifier, this.extension, properties2, this.file);
    }

    private static String expand(String pattern2, String replacement) {
        String result2 = "";
        if (pattern2 != null) {
            result2 = pattern2.replace("*", replacement);
            if (replacement.length() <= 0) {
                char c2;
                int i2;
                if (pattern2.startsWith("*")) {
                    for (i2 = 0; i2 < result2.length() && ((c2 = result2.charAt(i2)) == '-' || c2 == '.'); ++i2) {
                    }
                    result2 = result2.substring(i2);
                }
                if (pattern2.endsWith("*")) {
                    for (i2 = result2.length() - 1; i2 >= 0 && ((c2 = result2.charAt(i2)) == '-' || c2 == '.'); --i2) {
                    }
                    result2 = result2.substring(0, i2 + 1);
                }
            }
        }
        return result2;
    }
}

