/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.repository;

import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;

public final class AuthenticationContext
implements Closeable {
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String NTLM_DOMAIN = "ntlm.domain";
    public static final String NTLM_WORKSTATION = "ntlm.workstation";
    public static final String PRIVATE_KEY_PATH = "privateKey.path";
    public static final String PRIVATE_KEY_PASSPHRASE = "privateKey.passphrase";
    public static final String HOST_KEY_ACCEPTANCE = "hostKey.acceptance";
    public static final String HOST_KEY_REMOTE = "hostKey.remote";
    public static final String HOST_KEY_LOCAL = "hostKey.local";
    public static final String SSL_CONTEXT = "ssl.context";
    public static final String SSL_HOSTNAME_VERIFIER = "ssl.hostnameVerifier";
    private final RepositorySystemSession session;
    private final RemoteRepository repository;
    private final Proxy proxy;
    private final Authentication auth;
    private final Map<String, Object> authData;
    private boolean fillingAuthData;

    public static AuthenticationContext forRepository(RepositorySystemSession session2, RemoteRepository repository) {
        return AuthenticationContext.newInstance(session2, repository, null, repository.getAuthentication());
    }

    public static AuthenticationContext forProxy(RepositorySystemSession session2, RemoteRepository repository) {
        Proxy proxy;
        return AuthenticationContext.newInstance(session2, repository, proxy, (proxy = repository.getProxy()) != null ? proxy.getAuthentication() : null);
    }

    private static AuthenticationContext newInstance(RepositorySystemSession session2, RemoteRepository repository, Proxy proxy, Authentication auth) {
        if (auth == null) {
            return null;
        }
        return new AuthenticationContext(session2, repository, proxy, auth);
    }

    private AuthenticationContext(RepositorySystemSession session2, RemoteRepository repository, Proxy proxy, Authentication auth) {
        this.session = Objects.requireNonNull(session2, "repository system session cannot be null");
        this.repository = repository;
        this.proxy = proxy;
        this.auth = auth;
        this.authData = new HashMap<String, Object>();
    }

    public RepositorySystemSession getSession() {
        return this.session;
    }

    public RemoteRepository getRepository() {
        return this.repository;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String get(String key2) {
        return this.get(key2, null, String.class);
    }

    public <T> T get(String key2, Class<T> type2) {
        return this.get(key2, null, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key2, Map<String, String> data, Class<T> type2) {
        Object value2;
        Objects.requireNonNull(key2, "authentication key cannot be null");
        if (key2.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        Map<String, Object> map2 = this.authData;
        synchronized (map2) {
            value2 = this.authData.get(key2);
            if (value2 == null && !this.authData.containsKey(key2) && !this.fillingAuthData) {
                if (this.auth != null) {
                    try {
                        this.fillingAuthData = true;
                        this.auth.fill(this, key2, data);
                    }
                    finally {
                        this.fillingAuthData = false;
                    }
                    value2 = this.authData.get(key2);
                }
                if (value2 == null) {
                    this.authData.put(key2, value2);
                }
            }
        }
        return this.convert(value2, type2);
    }

    private <T> T convert(Object value2, Class<T> type2) {
        if (!type2.isInstance(value2)) {
            if (String.class.equals(type2)) {
                if (value2 instanceof File) {
                    value2 = ((File)value2).getPath();
                } else if (value2 instanceof char[]) {
                    value2 = new String((char[])value2);
                }
            } else if (File.class.equals(type2)) {
                if (value2 instanceof String) {
                    value2 = new File((String)value2);
                }
            } else if (char[].class.equals(type2) && value2 instanceof String) {
                value2 = ((String)value2).toCharArray();
            }
        }
        if (type2.isInstance(value2)) {
            return type2.cast(value2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key2, Object value2) {
        Objects.requireNonNull(key2, "authentication key cannot be null");
        if (key2.length() == 0) {
            throw new IllegalArgumentException("authentication key cannot be empty");
        }
        Map<String, Object> map2 = this.authData;
        synchronized (map2) {
            Object oldValue = this.authData.put(key2, value2);
            if (oldValue instanceof char[]) {
                Arrays.fill((char[])oldValue, '\u0000');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<String, Object> map2 = this.authData;
        synchronized (map2) {
            for (Object value2 : this.authData.values()) {
                if (!(value2 instanceof char[])) continue;
                Arrays.fill((char[])value2, '\u0000');
            }
            this.authData.clear();
        }
    }

    public static void close(AuthenticationContext context) {
        if (context != null) {
            context.close();
        }
    }
}

