/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.metadata;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;

public abstract class AbstractMetadata
implements Metadata {
    private Metadata newInstance(Map<String, String> properties2, File file) {
        return new DefaultMetadata(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getNature(), file, properties2);
    }

    @Override
    public Metadata setFile(File file) {
        File current = this.getFile();
        if (Objects.equals(current, file)) {
            return this;
        }
        return this.newInstance(this.getProperties(), file);
    }

    @Override
    public Metadata setProperties(Map<String, String> properties2) {
        Map<String, String> current = this.getProperties();
        if (current.equals(properties2) || properties2 == null && current.isEmpty()) {
            return this;
        }
        return this.newInstance(AbstractMetadata.copyProperties(properties2), this.getFile());
    }

    @Override
    public String getProperty(String key2, String defaultValue) {
        String value2 = this.getProperties().get(key2);
        return value2 != null ? value2 : defaultValue;
    }

    protected static Map<String, String> copyProperties(Map<String, String> properties2) {
        if (properties2 != null && !properties2.isEmpty()) {
            return Collections.unmodifiableMap(new HashMap<String, String>(properties2));
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (this.getGroupId().length() > 0) {
            buffer.append(this.getGroupId());
        }
        if (this.getArtifactId().length() > 0) {
            buffer.append(':').append(this.getArtifactId());
        }
        if (this.getVersion().length() > 0) {
            buffer.append(':').append(this.getVersion());
        }
        buffer.append('/').append(this.getType());
        return buffer.toString();
    }

    public boolean equals(Object obj2) {
        if (obj2 == this) {
            return true;
        }
        if (!(obj2 instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)obj2;
        return Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getType(), that.getType()) && Objects.equals((Object)this.getNature(), (Object)that.getNature()) && Objects.equals(this.getFile(), that.getFile()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getType().hashCode();
        hash = hash * 31 + this.getNature().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractMetadata.hash(this.getFile());
        return hash;
    }

    private static int hash(Object obj2) {
        return obj2 != null ? obj2.hashCode() : 0;
    }
}

