/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.impl.MetadataResolver;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.SyncContextFactory;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.internal.impl.SafeTransferListener;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.concurrency.RunnableErrorForwarder;
import org.eclipse.aether.util.concurrency.WorkerThreadFactory;

@Named
public class DefaultMetadataResolver
implements MetadataResolver,
Service {
    private static final String CONFIG_PROP_THREADS = "aether.metadataResolver.threads";
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private UpdateCheckManager updateCheckManager;
    private RepositoryConnectorProvider repositoryConnectorProvider;
    private RemoteRepositoryManager remoteRepositoryManager;
    private SyncContextFactory syncContextFactory;
    private OfflineController offlineController;

    public DefaultMetadataResolver() {
    }

    @Inject
    DefaultMetadataResolver(RepositoryEventDispatcher repositoryEventDispatcher, UpdateCheckManager updateCheckManager, RepositoryConnectorProvider repositoryConnectorProvider, RemoteRepositoryManager remoteRepositoryManager, SyncContextFactory syncContextFactory, OfflineController offlineController) {
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setUpdateCheckManager(updateCheckManager);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setUpdateCheckManager(locator.getService(UpdateCheckManager.class));
        this.setRepositoryConnectorProvider(locator.getService(RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
        this.setOfflineController(locator.getService(OfflineController.class));
    }

    public DefaultMetadataResolver setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultMetadataResolver setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public DefaultMetadataResolver setRepositoryConnectorProvider(RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public DefaultMetadataResolver setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public DefaultMetadataResolver setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public DefaultMetadataResolver setOfflineController(OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    @Override
    public List<MetadataResult> resolveMetadata(RepositorySystemSession session2, Collection<? extends MetadataRequest> requests) {
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session2, false);){
            ArrayList<Metadata> metadata = new ArrayList<Metadata>(requests.size());
            for (MetadataRequest metadataRequest : requests) {
                metadata.add(metadataRequest.getMetadata());
            }
            syncContext.acquire(null, metadata);
            List<MetadataResult> list = this.resolve(session2, requests);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MetadataResult> resolve(RepositorySystemSession session2, Collection<? extends MetadataRequest> requests) {
        Metadata metadata;
        ArrayList<MetadataResult> results2 = new ArrayList<MetadataResult>(requests.size());
        ArrayList<ResolveTask> tasks = new ArrayList<ResolveTask>(requests.size());
        HashMap<File, Long> localLastUpdates = new HashMap<File, Long>();
        for (MetadataRequest metadataRequest : requests) {
            File localFile;
            RequestTrace trace = RequestTrace.newChild(metadataRequest.getTrace(), metadataRequest);
            Iterator result2 = new MetadataResult(metadataRequest);
            results2.add((MetadataResult)((Object)result2));
            metadata = metadataRequest.getMetadata();
            RemoteRepository repository = metadataRequest.getRepository();
            if (repository == null) {
                LocalRepository localRepository = session2.getLocalRepositoryManager().getRepository();
                this.metadataResolving(session2, trace, metadata, localRepository);
                File localFile2 = this.getLocalFile(session2, metadata);
                if (localFile2 != null) {
                    metadata = metadata.setFile(localFile2);
                    ((MetadataResult)((Object)result2)).setMetadata(metadata);
                } else {
                    ((MetadataResult)((Object)result2)).setException(new MetadataNotFoundException(metadata, localRepository));
                }
                this.metadataResolved(session2, trace, metadata, localRepository, ((MetadataResult)((Object)result2)).getException());
                continue;
            }
            List<RemoteRepository> list = this.getEnabledSourceRepositories(repository, metadata.getNature());
            if (list.isEmpty()) continue;
            this.metadataResolving(session2, trace, metadata, repository);
            LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
            LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, repository, metadataRequest.getRequestContext());
            LocalMetadataResult lrmResult = lrm.find(session2, localRequest);
            File metadataFile = lrmResult.getFile();
            try {
                Utils.checkOffline(session2, this.offlineController, repository);
            }
            catch (RepositoryOfflineException e2) {
                if (metadataFile != null) {
                    metadata = metadata.setFile(metadataFile);
                    ((MetadataResult)((Object)result2)).setMetadata(metadata);
                } else {
                    String msg = "Cannot access " + repository.getId() + " (" + repository.getUrl() + ") in offline mode and the metadata " + metadata + " has not been downloaded from it before";
                    ((MetadataResult)((Object)result2)).setException(new MetadataNotFoundException(metadata, repository, msg, e2));
                }
                this.metadataResolved(session2, trace, metadata, repository, ((MetadataResult)((Object)result2)).getException());
                continue;
            }
            Long localLastUpdate = null;
            if (metadataRequest.isFavorLocalRepository() && (localLastUpdate = (Long)localLastUpdates.get(localFile = this.getLocalFile(session2, metadata))) == null) {
                localLastUpdate = localFile != null ? localFile.lastModified() : 0L;
                localLastUpdates.put(localFile, localLastUpdate);
            }
            ArrayList<UpdateCheck<Metadata, MetadataTransferException>> checks2 = new ArrayList<UpdateCheck<Metadata, MetadataTransferException>>();
            MetadataTransferException exception = null;
            for (RemoteRepository repo : list) {
                UpdateCheck<Metadata, MetadataTransferException> check = new UpdateCheck<Metadata, MetadataTransferException>();
                check.setLocalLastUpdated(localLastUpdate != null ? localLastUpdate : 0L);
                check.setItem(metadata);
                File checkFile = new File(session2.getLocalRepository().getBasedir(), session2.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, repository, metadataRequest.getRequestContext()));
                check.setFile(checkFile);
                check.setRepository(repository);
                check.setAuthoritativeRepository(repo);
                check.setPolicy(this.getPolicy(session2, repo, metadata.getNature()).getUpdatePolicy());
                if (lrmResult.isStale()) {
                    checks2.add(check);
                    continue;
                }
                this.updateCheckManager.checkMetadata(session2, check);
                if (check.isRequired()) {
                    checks2.add(check);
                    continue;
                }
                if (exception != null) continue;
                exception = check.getException();
            }
            if (!checks2.isEmpty()) {
                RepositoryPolicy policy = this.getPolicy(session2, repository, metadata.getNature());
                File installFile = new File(session2.getLocalRepository().getBasedir(), session2.getLocalRepositoryManager().getPathForRemoteMetadata(metadata, metadataRequest.getRepository(), metadataRequest.getRequestContext()));
                this.metadataDownloading(session2, trace, ((MetadataResult)((Object)result2)).getRequest().getMetadata(), ((MetadataResult)((Object)result2)).getRequest().getRepository());
                ResolveTask task = new ResolveTask(session2, trace, (MetadataResult)((Object)result2), installFile, (List<UpdateCheck<Metadata, MetadataTransferException>>)checks2, policy.getChecksumPolicy());
                tasks.add(task);
                continue;
            }
            ((MetadataResult)((Object)result2)).setException(exception);
            if (metadataFile != null) {
                metadata = metadata.setFile(metadataFile);
                ((MetadataResult)((Object)result2)).setMetadata(metadata);
            }
            this.metadataResolved(session2, trace, metadata, repository, ((MetadataResult)((Object)result2)).getException());
        }
        if (!tasks.isEmpty()) {
            int threads = ConfigUtils.getInteger(session2, 4, CONFIG_PROP_THREADS);
            Executor executor = this.getExecutor(Math.min(tasks.size(), threads));
            try {
                RunnableErrorForwarder errorForwarder = new RunnableErrorForwarder();
                for (ResolveTask task : tasks) {
                    executor.execute(errorForwarder.wrap(task));
                }
                errorForwarder.await();
                for (ResolveTask task : tasks) {
                    for (UpdateCheck updateCheck : task.checks) {
                        this.updateCheckManager.touchMetadata(task.session, updateCheck.setException(task.exception));
                    }
                    this.metadataDownloaded(session2, task.trace, task.request.getMetadata(), task.request.getRepository(), task.metadataFile, task.exception);
                    task.result.setException(task.exception);
                }
            }
            finally {
                this.shutdown(executor);
            }
            for (ResolveTask task : tasks) {
                metadata = task.request.getMetadata();
                LocalMetadataRequest localRequest = new LocalMetadataRequest(metadata, task.request.getRepository(), task.request.getRequestContext());
                File file = session2.getLocalRepositoryManager().find(session2, localRequest).getFile();
                if (file != null) {
                    metadata = metadata.setFile(file);
                    task.result.setMetadata(metadata);
                }
                if (task.result.getException() == null) {
                    task.result.setUpdated(true);
                }
                this.metadataResolved(session2, task.trace, metadata, task.request.getRepository(), task.result.getException());
            }
        }
        return results2;
    }

    private File getLocalFile(RepositorySystemSession session2, Metadata metadata) {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        LocalMetadataResult localResult = lrm.find(session2, new LocalMetadataRequest(metadata, null, null));
        return localResult.getFile();
    }

    private List<RemoteRepository> getEnabledSourceRepositories(RemoteRepository repository, Metadata.Nature nature) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        if (repository.isRepositoryManager()) {
            for (RemoteRepository repo : repository.getMirroredRepositories()) {
                if (!this.isEnabled(repo, nature)) continue;
                repositories.add(repo);
            }
        } else if (this.isEnabled(repository, nature)) {
            repositories.add(repository);
        }
        return repositories;
    }

    private boolean isEnabled(RemoteRepository repository, Metadata.Nature nature) {
        if (!Metadata.Nature.SNAPSHOT.equals((Object)nature) && repository.getPolicy(false).isEnabled()) {
            return true;
        }
        return !Metadata.Nature.RELEASE.equals((Object)nature) && repository.getPolicy(true).isEnabled();
    }

    private RepositoryPolicy getPolicy(RepositorySystemSession session2, RemoteRepository repository, Metadata.Nature nature) {
        boolean releases = !Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session2, repository, releases, snapshots);
    }

    private void metadataResolving(RepositorySystemSession session2, RequestTrace trace, Metadata metadata, ArtifactRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_RESOLVING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataResolved(RepositorySystemSession session2, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_RESOLVED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(metadata.getFile());
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataDownloading(RepositorySystemSession session2, RequestTrace trace, Metadata metadata, ArtifactRepository repository) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_DOWNLOADING);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void metadataDownloaded(RepositorySystemSession session2, RequestTrace trace, Metadata metadata, ArtifactRepository repository, File file, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_DOWNLOADED);
        event.setTrace(trace);
        event.setMetadata(metadata);
        event.setRepository(repository);
        event.setException(exception);
        event.setFile(file);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private Executor getExecutor(int threads) {
        if (threads <= 1) {
            return new Executor(){

                @Override
                public void execute(Runnable command2) {
                    command2.run();
                }
            };
        }
        return new ThreadPoolExecutor(threads, threads, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new WorkerThreadFactory(null));
    }

    private void shutdown(Executor executor) {
        if (executor instanceof ExecutorService) {
            ((ExecutorService)executor).shutdown();
        }
    }

    class ResolveTask
    implements Runnable {
        final RepositorySystemSession session;
        final RequestTrace trace;
        final MetadataResult result;
        final MetadataRequest request;
        final File metadataFile;
        final String policy;
        final List<UpdateCheck<Metadata, MetadataTransferException>> checks;
        volatile MetadataTransferException exception;

        ResolveTask(RepositorySystemSession session2, RequestTrace trace, MetadataResult result2, File metadataFile, List<UpdateCheck<Metadata, MetadataTransferException>> checks2, String policy) {
            this.session = session2;
            this.trace = trace;
            this.result = result2;
            this.request = result2.getRequest();
            this.metadataFile = metadataFile;
            this.policy = policy;
            this.checks = checks2;
        }

        @Override
        public void run() {
            Metadata metadata = this.request.getMetadata();
            RemoteRepository requestRepository = this.request.getRepository();
            try {
                ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
                for (UpdateCheck<Metadata, MetadataTransferException> check : this.checks) {
                    repositories.add(check.getAuthoritativeRepository());
                }
                MetadataDownload download = new MetadataDownload();
                download.setMetadata(metadata);
                download.setRequestContext(this.request.getRequestContext());
                download.setFile(this.metadataFile);
                download.setChecksumPolicy(this.policy);
                download.setRepositories(repositories);
                download.setListener(SafeTransferListener.wrap(this.session));
                download.setTrace(this.trace);
                try (RepositoryConnector connector = DefaultMetadataResolver.this.repositoryConnectorProvider.newRepositoryConnector(this.session, requestRepository);){
                    connector.get(null, Arrays.asList(download));
                }
                this.exception = download.getException();
                if (this.exception == null) {
                    List<String> contexts = Collections.singletonList(this.request.getRequestContext());
                    LocalMetadataRegistration registration = new LocalMetadataRegistration(metadata, requestRepository, contexts);
                    this.session.getLocalRepositoryManager().add(this.session, registration);
                } else if (this.request.isDeleteLocalCopyIfMissing() && this.exception instanceof MetadataNotFoundException) {
                    download.getFile().delete();
                }
            }
            catch (NoRepositoryConnectorException e2) {
                this.exception = new MetadataTransferException(metadata, requestRepository, e2);
            }
        }
    }
}

