/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.collection;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.version.VersionConstraint;

public class UnsolvableVersionConflictException
extends RepositoryException {
    private final transient Collection<String> versions;
    private final transient Collection<? extends List<? extends DependencyNode>> paths;

    public UnsolvableVersionConflictException(Collection<? extends List<? extends DependencyNode>> paths2) {
        super("Could not resolve version conflict among " + UnsolvableVersionConflictException.toPaths(paths2));
        if (paths2 == null) {
            this.paths = Collections.emptyList();
            this.versions = Collections.emptyList();
        } else {
            this.paths = paths2;
            this.versions = new LinkedHashSet<String>();
            for (List<? extends DependencyNode> list : paths2) {
                VersionConstraint constraint = list.get(list.size() - 1).getVersionConstraint();
                if (constraint == null || constraint.getRange() == null) continue;
                this.versions.add(constraint.toString());
            }
        }
    }

    private static String toPaths(Collection<? extends List<? extends DependencyNode>> paths2) {
        String result2 = "";
        if (paths2 != null) {
            LinkedHashSet<String> strings = new LinkedHashSet<String>();
            for (List<? extends DependencyNode> list : paths2) {
                strings.add(UnsolvableVersionConflictException.toPath(list));
            }
            result2 = ((Object)strings).toString();
        }
        return result2;
    }

    private static String toPath(List<? extends DependencyNode> path) {
        StringBuilder buffer = new StringBuilder(256);
        Iterator<? extends DependencyNode> it2 = path.iterator();
        while (it2.hasNext()) {
            DependencyNode node2 = it2.next();
            if (node2.getDependency() == null) continue;
            Artifact artifact = node2.getDependency().getArtifact();
            buffer.append(artifact.getGroupId());
            buffer.append(':').append(artifact.getArtifactId());
            buffer.append(':').append(artifact.getExtension());
            if (artifact.getClassifier().length() > 0) {
                buffer.append(':').append(artifact.getClassifier());
            }
            buffer.append(':').append(node2.getVersionConstraint());
            if (!it2.hasNext()) continue;
            buffer.append(" -> ");
        }
        return buffer.toString();
    }

    public Collection<? extends List<? extends DependencyNode>> getPaths() {
        return this.paths;
    }

    public Collection<String> getVersions() {
        return this.versions;
    }
}

