/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class Xpp3DomBuilder {
    private static final boolean DEFAULT_TRIM = true;

    public static Xpp3Dom build(Reader reader) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, null);
    }

    public static Xpp3Dom build(Reader reader, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, true, locationBuilder);
    }

    public static Xpp3Dom build(InputStream is, String encoding) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(is, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(InputStream is, String encoding, boolean trim) throws XmlPullParserException, IOException {
        try {
            MXParser parser2 = new MXParser();
            parser2.setInput(is, encoding);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser2, trim);
            is.close();
            is = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(is);
        }
    }

    public static Xpp3Dom build(Reader reader, boolean trim) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(reader, trim, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xpp3Dom build(Reader reader, boolean trim, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        try {
            MXParser parser2 = new MXParser();
            parser2.setInput(reader);
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(parser2, trim, locationBuilder);
            reader.close();
            reader = null;
            Xpp3Dom xpp3Dom2 = xpp3Dom;
            return xpp3Dom2;
        }
        finally {
            IOUtil.close(reader);
        }
    }

    public static Xpp3Dom build(XmlPullParser parser2) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser2, true);
    }

    public static Xpp3Dom build(XmlPullParser parser2, boolean trim) throws XmlPullParserException, IOException {
        return Xpp3DomBuilder.build(parser2, trim, null);
    }

    public static Xpp3Dom build(XmlPullParser parser2, boolean trim, InputLocationBuilder locationBuilder) throws XmlPullParserException, IOException {
        ArrayList<Xpp3Dom> elements2 = new ArrayList<Xpp3Dom>();
        ArrayList<StringBuilder> values2 = new ArrayList<StringBuilder>();
        int eventType = parser2.getEventType();
        boolean spacePreserve = false;
        while (eventType != 1) {
            if (eventType == 2) {
                int depth;
                spacePreserve = false;
                String rawName = parser2.getName();
                Xpp3Dom childConfiguration = new Xpp3Dom(rawName);
                if (locationBuilder != null) {
                    childConfiguration.setInputLocation(locationBuilder.toInputLocation(parser2));
                }
                if ((depth = elements2.size()) > 0) {
                    Xpp3Dom parent2 = (Xpp3Dom)elements2.get(depth - 1);
                    parent2.addChild(childConfiguration);
                }
                elements2.add(childConfiguration);
                if (parser2.isEmptyElementTag()) {
                    values2.add(null);
                } else {
                    values2.add(new StringBuilder());
                }
                int attributesSize = parser2.getAttributeCount();
                for (int i2 = 0; i2 < attributesSize; ++i2) {
                    String name2 = parser2.getAttributeName(i2);
                    String value2 = parser2.getAttributeValue(i2);
                    childConfiguration.setAttribute(name2, value2);
                    spacePreserve = spacePreserve || "xml:space".equals(name2) && "preserve".equals(value2);
                }
            } else if (eventType == 4) {
                int depth = values2.size() - 1;
                StringBuilder valueBuffer = (StringBuilder)values2.get(depth);
                String text2 = parser2.getText();
                if (trim && !spacePreserve) {
                    text2 = text2.trim();
                }
                valueBuffer.append(text2);
            } else if (eventType == 3) {
                int depth = elements2.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom)elements2.remove(depth);
                Object accumulatedValue = values2.remove(depth);
                if (finishedConfiguration.getChildCount() == 0) {
                    if (accumulatedValue == null) {
                        finishedConfiguration.setValue(null);
                    } else {
                        finishedConfiguration.setValue(accumulatedValue.toString());
                    }
                }
                if (depth == 0) {
                    return finishedConfiguration;
                }
            }
            eventType = parser2.next();
        }
        throw new IllegalStateException("End of document found before returning to 0 depth");
    }

    public static interface InputLocationBuilder {
        public Object toInputLocation(XmlPullParser var1);
    }
}

