/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class XmlUtil {
    public static final int DEFAULT_INDENTATION_SIZE = 2;
    public static final String DEFAULT_LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean isXml(File f) {
        boolean bl;
        block10: {
            if (f == null) {
                throw new IllegalArgumentException("f could not be null.");
            }
            if (!f.isFile()) {
                throw new IllegalArgumentException("The file '" + f.getAbsolutePath() + "' is not a file.");
            }
            XmlStreamReader reader = ReaderFactory.newXmlReader(f);
            try {
                MXParser parser2 = new MXParser();
                parser2.setInput(reader);
                parser2.nextToken();
                bl = true;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e2) {
                    return false;
                }
            }
            ((Reader)reader).close();
        }
        return bl;
    }

    public static void prettyFormat(Reader reader, Writer writer) throws IOException {
        XmlUtil.prettyFormat(reader, writer, 2, DEFAULT_LINE_SEPARATOR);
    }

    public static void prettyFormat(Reader reader, Writer writer, int indentSize, String lineSeparator) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("The reader is null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("The writer is null");
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer);
        xmlWriter.setLineIndenter(StringUtils.repeat(" ", indentSize));
        xmlWriter.setLineSeparator(lineSeparator);
        MXParser parser2 = new MXParser();
        try {
            parser2.setInput(reader);
            XmlUtil.prettyFormatInternal(parser2, xmlWriter);
        }
        catch (XmlPullParserException e2) {
            throw new IOException("Unable to parse the XML: " + e2.getMessage());
        }
    }

    public static void prettyFormat(InputStream is, OutputStream os) throws IOException {
        XmlUtil.prettyFormat(is, os, 2, DEFAULT_LINE_SEPARATOR);
    }

    public static void prettyFormat(InputStream is, OutputStream os, int indentSize, String lineSeparator) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("The is is null");
        }
        if (os == null) {
            throw new IllegalArgumentException("The os is null");
        }
        if (indentSize < 0) {
            indentSize = 0;
        }
        try (XmlStreamReader reader = ReaderFactory.newXmlReader(is);
             OutputStreamWriter writer = new OutputStreamWriter(os);){
            PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer);
            xmlWriter.setLineIndenter(StringUtils.repeat(" ", indentSize));
            xmlWriter.setLineSeparator(lineSeparator);
            MXParser parser2 = new MXParser();
            parser2.setInput(reader);
            XmlUtil.prettyFormatInternal(parser2, xmlWriter);
        }
        catch (XmlPullParserException e2) {
            throw new IOException("Unable to parse the XML: " + e2.getMessage());
        }
    }

    private static void prettyFormatInternal(XmlPullParser parser2, PrettyPrintXMLWriter writer) throws XmlPullParserException, IOException {
        boolean hasTag = false;
        boolean hasComment = false;
        int eventType = parser2.getEventType();
        while (eventType != 1) {
            int i2;
            if (eventType == 2) {
                hasTag = true;
                if (hasComment) {
                    writer.writeText(writer.getLineIndenter());
                    hasComment = false;
                }
                writer.startElement(parser2.getName());
                for (i2 = 0; i2 < parser2.getAttributeCount(); ++i2) {
                    String key2 = parser2.getAttributeName(i2);
                    String value2 = parser2.getAttributeValue(i2);
                    writer.addAttribute(key2, value2);
                }
            } else if (eventType == 4) {
                String text2 = parser2.getText();
                if (!text2.trim().equals("")) {
                    text2 = StringUtils.removeDuplicateWhitespace(text2);
                    writer.writeText(text2);
                }
            } else if (eventType == 3) {
                hasTag = false;
                writer.endElement();
            } else if (eventType == 9) {
                hasComment = true;
                if (!hasTag) {
                    writer.writeMarkup(writer.getLineSeparator());
                    for (i2 = 0; i2 < writer.getDepth(); ++i2) {
                        writer.writeMarkup(writer.getLineIndenter());
                    }
                }
                writer.writeMarkup("<!--" + parser2.getText().trim() + " -->");
                if (!hasTag) {
                    writer.writeMarkup(writer.getLineSeparator());
                    for (i2 = 0; i2 < writer.getDepth() - 1; ++i2) {
                        writer.writeMarkup(writer.getLineIndenter());
                    }
                }
            } else if (eventType == 10) {
                writer.writeMarkup("<!DOCTYPE" + parser2.getText() + ">");
                writer.endOfLine();
            } else if (eventType == 8) {
                writer.writeMarkup("<?" + parser2.getText() + "?>");
                writer.endOfLine();
            } else if (eventType == 5) {
                writer.writeMarkup("<![CDATA[" + parser2.getText() + "]]>");
            } else if (eventType == 6) {
                writer.writeMarkup("&" + parser2.getName() + ";");
            }
            eventType = parser2.nextToken();
        }
    }
}

