/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.util.reflection.ReflectorException;

public final class Reflector {
    private static final String CONSTRUCTOR_METHOD_NAME = "$$CONSTRUCTOR$$";
    private static final String GET_INSTANCE_METHOD_NAME = "getInstance";
    private Map<String, Map<String, Map<String, Method>>> classMaps = new HashMap<String, Map<String, Map<String, Method>>>();

    public <T> T newInstance(Class<T> theClass, Object[] params2) throws ReflectorException {
        if (params2 == null) {
            params2 = new Object[]{};
        }
        Class[] paramTypes = new Class[params2.length];
        int len = params2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            paramTypes[i2] = params2[i2].getClass();
        }
        try {
            Constructor<T> con = this.getConstructor(theClass, paramTypes);
            if (con == null) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Constructor not found for class: ");
                buffer.append(theClass.getName());
                buffer.append(" with specified or ancestor parameter classes: ");
                for (Class paramType : paramTypes) {
                    buffer.append(paramType.getName());
                    buffer.append(',');
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return con.newInstance(params2);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public <T> T getSingleton(Class<T> theClass, Object[] initParams) throws ReflectorException {
        Class[] paramTypes = new Class[initParams.length];
        int len = initParams.length;
        for (int i2 = 0; i2 < len; ++i2) {
            paramTypes[i2] = initParams[i2].getClass();
        }
        try {
            Method method = this.getMethod(theClass, GET_INSTANCE_METHOD_NAME, paramTypes);
            return (T)method.invoke(null, initParams);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object invoke(Object target2, String methodName, Object[] params2) throws ReflectorException {
        if (params2 == null) {
            params2 = new Object[]{};
        }
        Class[] paramTypes = new Class[params2.length];
        int len = params2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            paramTypes[i2] = params2[i2].getClass();
        }
        try {
            Method method = this.getMethod(target2.getClass(), methodName, paramTypes);
            if (method == null) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Singleton-producing method named '").append(methodName).append("' not found with specified parameter classes: ");
                for (Class paramType : paramTypes) {
                    buffer.append(paramType.getName());
                    buffer.append(',');
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return method.invoke(target2, params2);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    public Object getStaticField(Class targetClass, String fieldName) throws ReflectorException {
        try {
            Field field = targetClass.getField(fieldName);
            return field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e2) {
            throw new ReflectorException(e2);
        }
    }

    public Object getField(Object target2, String fieldName) throws ReflectorException {
        return this.getField(target2, fieldName, false);
    }

    public Object getField(Object target2, String fieldName, boolean breakAccessibility) throws ReflectorException {
        for (Class<?> targetClass = target2.getClass(); targetClass != null; targetClass = targetClass.getSuperclass()) {
            try {
                Field field = targetClass.getDeclaredField(fieldName);
                boolean accessibilityBroken = false;
                if (!field.isAccessible() && breakAccessibility) {
                    field.setAccessible(true);
                    accessibilityBroken = true;
                }
                Object result2 = field.get(target2);
                if (accessibilityBroken) {
                    field.setAccessible(false);
                }
                return result2;
            }
            catch (SecurityException e2) {
                throw new ReflectorException(e2);
            }
            catch (NoSuchFieldException e3) {
                if (targetClass != Object.class) continue;
                throw new ReflectorException(e3);
            }
            catch (IllegalAccessException e4) {
                throw new ReflectorException(e4);
            }
        }
        return null;
    }

    public Object invokeStatic(Class targetClass, String methodName, Object[] params2) throws ReflectorException {
        if (params2 == null) {
            params2 = new Object[]{};
        }
        Class[] paramTypes = new Class[params2.length];
        int len = params2.length;
        for (int i2 = 0; i2 < len; ++i2) {
            paramTypes[i2] = params2[i2].getClass();
        }
        try {
            Method method = this.getMethod(targetClass, methodName, paramTypes);
            if (method == null) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Singleton-producing method named '").append(methodName).append("' not found with specified parameter classes: ");
                for (Class paramType : paramTypes) {
                    buffer.append(paramType.getName());
                    buffer.append(',');
                }
                buffer.setLength(buffer.length() - 1);
                throw new ReflectorException(buffer.toString());
            }
            return method.invoke(null, params2);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new ReflectorException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Constructor<T> getConstructor(Class<T> targetClass, Class[] params2) throws ReflectorException {
        Constructor<Object> constructor;
        Map<String, Constructor<T>> constructorMap = this.getConstructorMap(targetClass);
        StringBuilder key2 = new StringBuilder(200);
        key2.append("(");
        for (Class param : params2) {
            key2.append(param.getName());
            key2.append(",");
        }
        if (params2.length > 0) {
            key2.setLength(key2.length() - 1);
        }
        key2.append(")");
        String paramKey = key2.toString();
        String string = paramKey.intern();
        synchronized (string) {
            constructor = constructorMap.get(paramKey);
            if (constructor == null) {
                Constructor<?>[] cands;
                for (Constructor<?> cand : cands = targetClass.getConstructors()) {
                    Class<?>[] types2 = cand.getParameterTypes();
                    if (params2.length != types2.length) continue;
                    int len2 = params2.length;
                    for (int j = 0; j < len2; ++j) {
                        if (types2[j].isAssignableFrom(params2[j])) continue;
                    }
                    constructor = cand;
                    constructorMap.put(paramKey, constructor);
                }
            }
        }
        if (constructor == null) {
            throw new ReflectorException("Error retrieving constructor object for: " + targetClass.getName() + paramKey);
        }
        return constructor;
    }

    public Object getObjectProperty(Object target2, String propertyName) throws ReflectorException {
        Object returnValue;
        Class[] emptyParams;
        Class<?> targetClass;
        Method method;
        if (propertyName == null || propertyName.trim().length() < 1) {
            throw new ReflectorException("Cannot retrieve value for empty property.");
        }
        String beanAccessor = "get" + Character.toUpperCase(propertyName.charAt(0));
        if (propertyName.trim().length() > 1) {
            beanAccessor = beanAccessor + propertyName.substring(1).trim();
        }
        if ((method = this._getMethod(targetClass = target2.getClass(), beanAccessor, emptyParams = new Class[0])) == null) {
            method = this._getMethod(targetClass, propertyName, emptyParams);
        }
        if (method != null) {
            try {
                returnValue = method.invoke(target2, new Object[0]);
            }
            catch (IllegalAccessException e2) {
                throw new ReflectorException("Error retrieving property '" + propertyName + "' from '" + targetClass + "'", e2);
            }
            catch (InvocationTargetException e3) {
                throw new ReflectorException("Error retrieving property '" + propertyName + "' from '" + targetClass + "'", e3);
            }
        }
        if (method != null) {
            try {
                returnValue = method.invoke(target2, new Object[0]);
            }
            catch (IllegalAccessException e4) {
                throw new ReflectorException("Error retrieving property '" + propertyName + "' from '" + targetClass + "'", e4);
            }
            catch (InvocationTargetException e5) {
                throw new ReflectorException("Error retrieving property '" + propertyName + "' from '" + targetClass + "'", e5);
            }
        } else {
            returnValue = this.getField(target2, propertyName, true);
            if (returnValue == null) {
                throw new ReflectorException("Neither method: '" + propertyName + "' nor bean accessor: '" + beanAccessor + "' can be found for class: '" + targetClass + "', and retrieval of field: '" + propertyName + "' returned null as value.");
            }
        }
        return returnValue;
    }

    public Method getMethod(Class targetClass, String methodName, Class[] params2) throws ReflectorException {
        Method method = this._getMethod(targetClass, methodName, params2);
        if (method == null) {
            throw new ReflectorException("Method: '" + methodName + "' not found in class: '" + targetClass + "'");
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method _getMethod(Class targetClass, String methodName, Class[] params2) throws ReflectorException {
        Method method;
        Map<String, ?> methodMap2 = this.getMethodMap(targetClass, methodName);
        StringBuilder key2 = new StringBuilder(200);
        key2.append("(");
        for (Class param : params2) {
            key2.append(param.getName());
            key2.append(",");
        }
        key2.append(")");
        String paramKey = key2.toString();
        String string = paramKey.intern();
        synchronized (string) {
            method = (Method)methodMap2.get(paramKey);
            if (method == null) {
                Method[] cands;
                for (Method cand : cands = targetClass.getMethods()) {
                    Class<?>[] types2;
                    String name2 = cand.getName();
                    if (!methodName.equals(name2) || params2.length != (types2 = cand.getParameterTypes()).length) continue;
                    int len2 = params2.length;
                    for (int j = 0; j < len2; ++j) {
                        if (types2[j].isAssignableFrom(params2[j])) continue;
                    }
                    method = cand;
                    methodMap2.put(paramKey, method);
                }
            }
        }
        return method;
    }

    private <T> Map<String, Constructor<T>> getConstructorMap(Class<T> theClass) throws ReflectorException {
        return this.getMethodMap(theClass, CONSTRUCTOR_METHOD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> getMethodMap(Class theClass, String methodName) throws ReflectorException {
        Map<Object, Object> methodMap2;
        if (theClass == null) {
            return null;
        }
        String className = theClass.getName();
        String string = className.intern();
        synchronized (string) {
            Map<String, Map<String, Method>> classMethods = this.classMaps.get(className);
            if (classMethods == null) {
                classMethods = new HashMap<String, Map<String, Method>>();
                methodMap2 = new HashMap();
                classMethods.put(methodName, methodMap2);
                this.classMaps.put(className, classMethods);
            } else {
                String key2 = className + "::" + methodName;
                String string2 = key2.intern();
                synchronized (string2) {
                    methodMap2 = classMethods.get(methodName);
                    if (methodMap2 == null) {
                        methodMap2 = new HashMap();
                        classMethods.put(methodName, methodMap2);
                    }
                }
            }
        }
        return methodMap2;
    }
}

