/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.ArrayList;

public class SweeperPool {
    private static final boolean DEBUG = false;
    private transient Sweeper sweeper;
    private transient int maxSize;
    private transient int minSize;
    private int triggerSize;
    private ArrayList<Object> pooledObjects;
    private boolean shuttingDown = false;

    public SweeperPool(int maxSize, int minSize, int intialCapacity, int sweepInterval, int triggerSize) {
        this.maxSize = this.saneConvert(maxSize);
        this.minSize = this.saneConvert(minSize);
        this.triggerSize = this.saneConvert(triggerSize);
        this.pooledObjects = new ArrayList(intialCapacity);
        if (sweepInterval > 0) {
            this.sweeper = new Sweeper(this, sweepInterval);
            this.sweeper.start();
        }
    }

    private int saneConvert(int value2) {
        return Math.max(value2, 0);
    }

    public synchronized Object get() {
        if (this.pooledObjects.size() == 0 || this.shuttingDown) {
            return null;
        }
        Object obj2 = this.pooledObjects.remove(0);
        this.objectRetrieved(obj2);
        return obj2;
    }

    public synchronized boolean put(Object obj2) {
        this.objectAdded(obj2);
        if (obj2 != null && this.pooledObjects.size() < this.maxSize && !this.shuttingDown) {
            this.pooledObjects.add(obj2);
            return true;
        }
        if (obj2 != null) {
            this.objectDisposed(obj2);
        }
        return false;
    }

    public synchronized int getSize() {
        return this.pooledObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.shuttingDown = true;
        if (this.sweeper != null) {
            this.sweeper.stop();
            try {
                this.sweeper.join();
            }
            catch (InterruptedException e2) {
                System.err.println("Unexpected exception occurred: ");
                e2.printStackTrace();
            }
        }
        SweeperPool sweeperPool = this;
        synchronized (sweeperPool) {
            Object[] objects2;
            for (Object object : objects2 = this.pooledObjects.toArray()) {
                this.objectDisposed(object);
            }
            this.pooledObjects.clear();
        }
    }

    boolean isDisposed() {
        if (!this.shuttingDown) {
            return false;
        }
        if (this.sweeper == null) {
            return true;
        }
        return this.sweeper.hasStopped();
    }

    public synchronized void trim() {
        if (this.triggerSize > 0 && this.pooledObjects.size() >= this.triggerSize || this.maxSize > 0 && this.pooledObjects.size() >= this.maxSize) {
            while (this.pooledObjects.size() > this.minSize) {
                this.objectDisposed(this.pooledObjects.remove(0));
            }
        }
    }

    public void objectDisposed(Object obj2) {
    }

    public void objectAdded(Object obj2) {
    }

    public void objectRetrieved(Object obj2) {
    }

    private static class Sweeper
    implements Runnable {
        private final transient SweeperPool pool;
        private transient boolean service = false;
        private final transient int sweepInterval;
        private transient Thread t = null;

        public Sweeper(SweeperPool pool, int sweepInterval) {
            this.sweepInterval = sweepInterval;
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.debug("started");
            if (this.sweepInterval > 0) {
                Sweeper sweeper = this;
                synchronized (sweeper) {
                    while (this.service) {
                        try {
                            this.wait(this.sweepInterval * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.runSweep();
                    }
                }
            }
            this.debug("stopped");
        }

        public void start() {
            if (!this.service) {
                this.service = true;
                this.t = new Thread(this);
                this.t.setName("Sweeper");
                this.t.start();
            }
        }

        public synchronized void stop() {
            this.service = false;
            this.notifyAll();
        }

        void join() throws InterruptedException {
            this.t.join();
        }

        boolean hasStopped() {
            return !this.service && !this.t.isAlive();
        }

        private final void debug(String msg) {
        }

        private void runSweep() {
            this.debug("runningSweep. time=" + System.currentTimeMillis());
            this.pool.trim();
        }
    }
}

