/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.codehaus.plexus.util.MatchPattern;

public final class SelectorUtils {
    public static final String PATTERN_HANDLER_PREFIX = "[";
    public static final String PATTERN_HANDLER_SUFFIX = "]";
    public static final String REGEX_HANDLER_PREFIX = "%regex[";
    public static final String ANT_HANDLER_PREFIX = "%ant[";
    private static SelectorUtils instance = new SelectorUtils();

    private SelectorUtils() {
    }

    public static SelectorUtils getInstance() {
        return instance;
    }

    public static boolean matchPatternStart(String pattern2, String str) {
        return SelectorUtils.matchPatternStart(pattern2, str, true);
    }

    public static boolean matchPatternStart(String pattern2, String str, boolean isCaseSensitive) {
        if (SelectorUtils.isRegexPrefixedPattern(pattern2)) {
            return true;
        }
        if (SelectorUtils.isAntPrefixedPattern(pattern2)) {
            pattern2 = pattern2.substring(ANT_HANDLER_PREFIX.length(), pattern2.length() - PATTERN_HANDLER_SUFFIX.length());
        }
        String altStr = str.replace('\\', '/');
        return SelectorUtils.matchAntPathPatternStart(pattern2, str, File.separator, isCaseSensitive) || SelectorUtils.matchAntPathPatternStart(pattern2, altStr, "/", isCaseSensitive);
    }

    static boolean isAntPrefixedPattern(String pattern2) {
        return pattern2.length() > ANT_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern2.startsWith(ANT_HANDLER_PREFIX) && pattern2.endsWith(PATTERN_HANDLER_SUFFIX);
    }

    static boolean matchAntPathPatternStart(MatchPattern pattern2, String str, String separator, boolean isCaseSensitive) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(pattern2, str, separator)) {
            return false;
        }
        return SelectorUtils.matchAntPathPatternStart(pattern2.getTokenizedPathString(), str, separator, isCaseSensitive);
    }

    static boolean matchAntPathPatternStart(String pattern2, String str, String separator, boolean isCaseSensitive) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(pattern2, str, separator)) {
            return false;
        }
        String[] patDirs = SelectorUtils.tokenizePathToString(pattern2, separator);
        return SelectorUtils.matchAntPathPatternStart(patDirs, str, separator, isCaseSensitive);
    }

    private static boolean separatorPatternStartSlashMismatch(String pattern2, String str, String separator) {
        return str.startsWith(separator) != pattern2.startsWith(separator);
    }

    private static boolean separatorPatternStartSlashMismatch(MatchPattern matchPattern, String str, String separator) {
        return str.startsWith(separator) != matchPattern.startsWith(separator);
    }

    static boolean matchAntPathPatternStart(String[] patDirs, String str, String separator, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        String[] strDirs = SelectorUtils.tokenizePathToString(str, separator);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxStart]).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            return false;
        }
        return strIdxStart > strIdxEnd || patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern2, String str) {
        return SelectorUtils.matchPath(pattern2, str, true);
    }

    public static boolean matchPath(String pattern2, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern2, str, File.separator, isCaseSensitive);
    }

    public static boolean matchPath(String pattern2, String str, String separator, boolean isCaseSensitive) {
        if (SelectorUtils.isRegexPrefixedPattern(pattern2)) {
            String localPattern = pattern2.substring(REGEX_HANDLER_PREFIX.length(), pattern2.length() - PATTERN_HANDLER_SUFFIX.length());
            return str.matches(localPattern);
        }
        String localPattern = SelectorUtils.isAntPrefixedPattern(pattern2) ? pattern2.substring(ANT_HANDLER_PREFIX.length(), pattern2.length() - PATTERN_HANDLER_SUFFIX.length()) : pattern2;
        String osRelatedPath = SelectorUtils.toOSRelatedPath(str, separator);
        String osRelatedPattern = SelectorUtils.toOSRelatedPath(localPattern, separator);
        return SelectorUtils.matchAntPathPattern(osRelatedPattern, osRelatedPath, separator, isCaseSensitive);
    }

    private static String toOSRelatedPath(String pattern2, String separator) {
        if ("/".equals(separator)) {
            return pattern2.replace("\\", separator);
        }
        if ("\\".equals(separator)) {
            return pattern2.replace("/", separator);
        }
        return pattern2;
    }

    static boolean isRegexPrefixedPattern(String pattern2) {
        return pattern2.length() > REGEX_HANDLER_PREFIX.length() + PATTERN_HANDLER_SUFFIX.length() + 1 && pattern2.startsWith(REGEX_HANDLER_PREFIX) && pattern2.endsWith(PATTERN_HANDLER_SUFFIX);
    }

    static boolean matchAntPathPattern(MatchPattern matchPattern, String str, String separator, boolean isCaseSensitive) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(matchPattern, str, separator)) {
            return false;
        }
        String[] patDirs = matchPattern.getTokenizedPathString();
        String[] strDirs = SelectorUtils.tokenizePathToString(str, separator);
        return SelectorUtils.matchAntPathPattern(patDirs, strDirs, isCaseSensitive);
    }

    static boolean matchAntPathPattern(String pattern2, String str, String separator, boolean isCaseSensitive) {
        if (SelectorUtils.separatorPatternStartSlashMismatch(pattern2, str, separator)) {
            return false;
        }
        String[] patDirs = SelectorUtils.tokenizePathToString(pattern2, separator);
        String[] strDirs = SelectorUtils.tokenizePathToString(str, separator);
        return SelectorUtils.matchAntPathPattern(patDirs, strDirs, isCaseSensitive);
    }

    static boolean matchAntPathPattern(String[] patDirs, String[] strDirs, boolean isCaseSensitive) {
        String patDir;
        int strIdxStart;
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxStart]).equals("**"); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (patDirs[i2].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !(patDir = patDirs[patIdxEnd]).equals("**")) {
            if (!SelectorUtils.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patDirs[i3].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                if (!patDirs[i4].equals("**")) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j = 0; j < patLength; ++j) {
                    String subPat = patDirs[patIdxStart + j + 1];
                    String subStr = strDirs[strIdxStart + i5 + j];
                    if (!SelectorUtils.match(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            if (patDirs[i6].equals("**")) continue;
            return false;
        }
        return true;
    }

    static boolean matchAntPathPattern(char[][] patDirs, char[][] strDirs, boolean isCaseSensitive) {
        char[] patDir;
        int strIdxStart;
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxEnd = strDirs.length - 1;
        for (strIdxStart = 0; patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !SelectorUtils.isDoubleStar(patDir = patDirs[patIdxStart]); ++patIdxStart, ++strIdxStart) {
            if (SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) continue;
            return false;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i2 = patIdxStart; i2 <= patIdxEnd; ++i2) {
                if (SelectorUtils.isDoubleStar(patDirs[i2])) continue;
                return false;
            }
            return true;
        }
        if (patIdxStart > patIdxEnd) {
            return false;
        }
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd && !SelectorUtils.isDoubleStar(patDir = patDirs[patIdxEnd])) {
            if (!SelectorUtils.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (SelectorUtils.isDoubleStar(patDirs[i3])) continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i4 = patIdxStart + 1; i4 <= patIdxEnd; ++i4) {
                if (!SelectorUtils.isDoubleStar(patDirs[i4])) continue;
                patIdxTmp = i4;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block6: for (int i5 = 0; i5 <= strLength - patLength; ++i5) {
                for (int j = 0; j < patLength; ++j) {
                    char[] subPat = patDirs[patIdxStart + j + 1];
                    char[] subStr = strDirs[strIdxStart + i5 + j];
                    if (!SelectorUtils.match(subPat, subStr, isCaseSensitive)) continue block6;
                }
                foundIdx = strIdxStart + i5;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i6 = patIdxStart; i6 <= patIdxEnd; ++i6) {
            if (SelectorUtils.isDoubleStar(patDirs[i6])) continue;
            return false;
        }
        return true;
    }

    private static boolean isDoubleStar(char[] patDir) {
        return patDir != null && patDir.length == 2 && patDir[0] == '*' && patDir[1] == '*';
    }

    public static boolean match(String pattern2, String str) {
        return SelectorUtils.match(pattern2, str, true);
    }

    public static boolean match(String pattern2, String str, boolean isCaseSensitive) {
        char[] patArr = pattern2.toCharArray();
        char[] strArr = str.toCharArray();
        return SelectorUtils.match(patArr, strArr, isCaseSensitive);
    }

    public static boolean match(char[] patArr, char[] strArr, boolean isCaseSensitive) {
        char ch;
        int patIdxStart = 0;
        int patIdxEnd = patArr.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strArr.length - 1;
        boolean containsStar = false;
        for (char aPatArr : patArr) {
            if (aPatArr != '*') continue;
            containsStar = true;
            break;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            for (int i2 = 0; i2 <= patIdxEnd; ++i2) {
                char ch2 = patArr[i2];
                if (ch2 == '?' || SelectorUtils.equals(ch2, strArr[i2], isCaseSensitive)) continue;
                return false;
            }
            return true;
        }
        if (patIdxEnd == 0) {
            return true;
        }
        while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i3 = patIdxStart; i3 <= patIdxEnd; ++i3) {
                if (patArr[i3] == '*') continue;
                return false;
            }
            return true;
        }
        while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd) {
            if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxEnd], isCaseSensitive)) {
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
        }
        if (strIdxStart > strIdxEnd) {
            for (int i4 = patIdxStart; i4 <= patIdxEnd; ++i4) {
                if (patArr[i4] == '*') continue;
                return false;
            }
            return true;
        }
        while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd) {
            int patIdxTmp = -1;
            for (int i5 = patIdxStart + 1; i5 <= patIdxEnd; ++i5) {
                if (patArr[i5] != '*') continue;
                patIdxTmp = i5;
                break;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            int patLength = patIdxTmp - patIdxStart - 1;
            int strLength = strIdxEnd - strIdxStart + 1;
            int foundIdx = -1;
            block8: for (int i6 = 0; i6 <= strLength - patLength; ++i6) {
                for (int j = 0; j < patLength; ++j) {
                    ch = patArr[patIdxStart + j + 1];
                    if (ch != '?' && !SelectorUtils.equals(ch, strArr[strIdxStart + i6 + j], isCaseSensitive)) continue block8;
                }
                foundIdx = strIdxStart + i6;
                break;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
        }
        for (int i7 = patIdxStart; i7 <= patIdxEnd; ++i7) {
            if (patArr[i7] == '*') continue;
            return false;
        }
        return true;
    }

    private static boolean equals(char c1, char c2, boolean isCaseSensitive) {
        if (c1 == c2) {
            return true;
        }
        return !isCaseSensitive && (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2));
    }

    private static String[] tokenizePathToString(String path, String separator) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.add(st.nextToken());
        }
        return ret.toArray(new String[0]);
    }

    public static boolean isOutOfDate(File src2, File target2, int granularity) {
        if (!src2.exists()) {
            return false;
        }
        if (!target2.exists()) {
            return true;
        }
        return src2.lastModified() - (long)granularity > target2.lastModified();
    }

    public static String removeWhitespace(String input) {
        StringBuilder result2 = new StringBuilder();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result2.append(st.nextToken());
            }
        }
        return result2.toString();
    }
}

