/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jettison.mapped;

import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.jettison.AbstractXMLInputFactory;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;

public class MappedXMLInputFactory
extends AbstractXMLInputFactory {
    private MappedNamespaceConvention convention;

    public MappedXMLInputFactory(Map nstojns) {
        this(new Configuration(nstojns));
    }

    public MappedXMLInputFactory(Configuration config) {
        this.convention = new MappedNamespaceConvention(config);
    }

    @Override
    public XMLStreamReader createXMLStreamReader(JSONTokener tokener) throws XMLStreamException {
        try {
            JSONObject root2 = this.createJSONObject(tokener);
            return new MappedXMLStreamReader(root2, this.convention);
        }
        catch (JSONException e2) {
            int column2 = e2.getColumn();
            if (column2 == -1) {
                throw new XMLStreamException(e2);
            }
            throw new XMLStreamException(e2.getMessage(), new ErrorLocation(e2.getLine(), e2.getColumn()), e2);
        }
    }

    protected JSONObject createJSONObject(JSONTokener tokener) throws JSONException {
        return new JSONObject(tokener);
    }

    private static class ErrorLocation
    implements Location {
        private int line = -1;
        private int column = -1;

        public ErrorLocation(int line, int column2) {
            this.line = line;
            this.column = column2;
        }

        @Override
        public int getCharacterOffset() {
            return 0;
        }

        @Override
        public int getColumnNumber() {
            return this.column;
        }

        @Override
        public int getLineNumber() {
            return this.line;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }
    }
}

