/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3ReaderEx;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named
@Singleton
public class DefaultModelReader
implements ModelReader {
    @Override
    public Model read(File input, Map<String, ?> options2) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        Model model2 = this.read(new FileInputStream(input), options2);
        model2.setPomFile(input);
        return model2;
    }

    @Override
    public Model read(Reader input, Map<String, ?> options2) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (Reader in = input;){
            Model model2 = this.read(in, this.isStrict(options2), this.getSource(options2));
            return model2;
        }
    }

    @Override
    public Model read(InputStream input, Map<String, ?> options2) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (XmlStreamReader in = ReaderFactory.newXmlReader(input);){
            Model model2 = this.read(in, this.isStrict(options2), this.getSource(options2));
            return model2;
        }
    }

    private boolean isStrict(Map<String, ?> options2) {
        Object value2 = options2 != null ? (Object)options2.get("org.apache.maven.model.io.isStrict") : null;
        return value2 == null || Boolean.parseBoolean(value2.toString());
    }

    private InputSource getSource(Map<String, ?> options2) {
        Object value2 = options2 != null ? options2.get("org.apache.maven.model.io.inputSource") : null;
        return value2;
    }

    private Model read(Reader reader, boolean strict, InputSource source) throws IOException {
        try {
            if (source != null) {
                return new MavenXpp3ReaderEx().read(reader, strict, source);
            }
            return new MavenXpp3Reader().read(reader, strict);
        }
        catch (XmlPullParserException e2) {
            throw new ModelParseException(e2.getMessage(), e2.getLineNumber(), e2.getColumnNumber(), e2);
        }
    }
}

