/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProblem;

public class ModelProblemUtils {
    static String toSourceHint(Model model2) {
        if (model2 == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(ModelProblemUtils.toId(model2));
        File pomFile = model2.getPomFile();
        if (pomFile != null) {
            buffer.append(" (").append(pomFile).append(')');
        }
        return buffer.toString();
    }

    static String toPath(Model model2) {
        File pomFile;
        String path = "";
        if (model2 != null && (pomFile = model2.getPomFile()) != null) {
            path = pomFile.getAbsolutePath();
        }
        return path;
    }

    static String toId(Model model2) {
        if (model2 == null) {
            return "";
        }
        String groupId = model2.getGroupId();
        if (groupId == null && model2.getParent() != null) {
            groupId = model2.getParent().getGroupId();
        }
        String artifactId = model2.getArtifactId();
        String version = model2.getVersion();
        if (version == null && model2.getParent() != null) {
            version = model2.getParent().getVersion();
        }
        if (version == null) {
            version = "[unknown-version]";
        }
        return ModelProblemUtils.toId(groupId, artifactId, version);
    }

    static String toId(String groupId, String artifactId, String version) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(groupId != null && groupId.length() > 0 ? groupId : "[unknown-group-id]");
        buffer.append(':');
        buffer.append(artifactId != null && artifactId.length() > 0 ? artifactId : "[unknown-artifact-id]");
        buffer.append(':');
        buffer.append(version != null && version.length() > 0 ? version : "[unknown-version]");
        return buffer.toString();
    }

    public static String formatLocation(ModelProblem problem, String projectId) {
        StringBuilder buffer = new StringBuilder(256);
        if (!problem.getModelId().equals(projectId)) {
            buffer.append(problem.getModelId());
            if (problem.getSource().length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(problem.getSource());
            }
        }
        if (problem.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("line ").append(problem.getLineNumber());
        }
        if (problem.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("column ").append(problem.getColumnNumber());
        }
        return buffer.toString();
    }
}

