/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.binary;

import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.binary.Token;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class BinaryStreamWriter
implements ExtendedHierarchicalStreamWriter {
    private final IdRegistry idRegistry = new IdRegistry();
    private final DataOutputStream out;
    private final Token.Formatter tokenFormatter = new Token.Formatter();

    public BinaryStreamWriter(OutputStream outputStream) {
        this.out = new DataOutputStream(outputStream);
    }

    public void startNode(String name2) {
        this.write(new Token.StartNode(this.idRegistry.getId(name2)));
    }

    public void startNode(String name2, Class clazz) {
        this.startNode(name2);
    }

    public void addAttribute(String name2, String value2) {
        this.write(new Token.Attribute(this.idRegistry.getId(name2), value2));
    }

    public void setValue(String text2) {
        this.write(new Token.Value(text2));
    }

    public void endNode() {
        this.write(new Token.EndNode());
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e2) {
            throw new StreamException(e2);
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e2) {
            throw new StreamException(e2);
        }
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    private void write(Token token) {
        try {
            this.tokenFormatter.write(this.out, token);
        }
        catch (IOException e2) {
            throw new StreamException(e2);
        }
    }

    private class IdRegistry {
        private long nextId = 0L;
        private Map ids = new HashMap();

        private IdRegistry() {
        }

        public long getId(String value2) {
            Long id = (Long)this.ids.get(value2);
            if (id == null) {
                id = new Long(++this.nextId);
                this.ids.put(value2, id);
                BinaryStreamWriter.this.write(new Token.MapIdToValue(id, value2));
            }
            return id;
        }
    }
}

