/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakCache
extends AbstractMap {
    private final Map map;

    public WeakCache() {
        this(new WeakHashMap());
    }

    public WeakCache(Map map2) {
        this.map = map2;
    }

    public Object get(Object key2) {
        Reference reference = (Reference)this.map.get(key2);
        return reference != null ? reference.get() : null;
    }

    public Object put(Object key2, Object value2) {
        Reference ref2 = this.map.put(key2, this.createReference(value2));
        return ref2 == null ? null : ref2.get();
    }

    public Object remove(Object key2) {
        Reference ref2 = (Reference)this.map.remove(key2);
        return ref2 == null ? null : ref2.get();
    }

    protected Reference createReference(Object value2) {
        return new WeakReference<Object>(value2);
    }

    public boolean containsValue(final Object value2) {
        Boolean result2 = (Boolean)this.iterate(new Visitor(){

            public Object visit(Object element2) {
                return element2.equals(value2) ? Boolean.TRUE : null;
            }
        }, 0);
        return result2 == Boolean.TRUE;
    }

    public int size() {
        if (this.map.size() == 0) {
            return 0;
        }
        final int[] i2 = new int[]{0};
        this.iterate(new Visitor(){

            public Object visit(Object element2) {
                i2[0] = i2[0] + 1;
                return null;
            }
        }, 0);
        return i2[0];
    }

    public Collection values() {
        final ArrayList collection2 = new ArrayList();
        if (this.map.size() != 0) {
            this.iterate(new Visitor(){

                public Object visit(Object element2) {
                    collection2.add(element2);
                    return null;
                }
            }, 0);
        }
        return collection2;
    }

    public Set entrySet() {
        final HashSet set = new HashSet();
        if (this.map.size() != 0) {
            this.iterate(new Visitor(){

                public Object visit(Object element2) {
                    final Map.Entry entry = (Map.Entry)element2;
                    set.add(new Map.Entry(){

                        public Object getKey() {
                            return entry.getKey();
                        }

                        public Object getValue() {
                            return ((Reference)entry.getValue()).get();
                        }

                        public Object setValue(Object value2) {
                            Reference reference = entry.setValue(WeakCache.this.createReference(value2));
                            return reference != null ? reference.get() : null;
                        }
                    });
                    return null;
                }
            }, 2);
        }
        return set;
    }

    private Object iterate(Visitor visitor2, int type2) {
        Object result2 = null;
        Iterator iter = this.map.entrySet().iterator();
        while (result2 == null && iter.hasNext()) {
            Map.Entry entry = iter.next();
            Reference reference = (Reference)entry.getValue();
            Object element2 = reference.get();
            if (element2 == null) {
                iter.remove();
                continue;
            }
            switch (type2) {
                case 0: {
                    result2 = visitor2.visit(element2);
                    break;
                }
                case 1: {
                    result2 = visitor2.visit(entry.getKey());
                    break;
                }
                case 2: {
                    result2 = visitor2.visit(entry);
                }
            }
        }
        return result2;
    }

    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public boolean equals(Object o2) {
        return this.map.equals(o2);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    private static interface Visitor {
        public Object visit(Object var1);
    }
}

