/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class ObjectIdDictionary {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public void associateId(Object obj2, Object id) {
        this.map.put(new WeakIdWrapper(obj2), id);
        this.cleanup();
    }

    public Object lookupId(Object obj2) {
        Object id = this.map.get(new IdWrapper(obj2));
        return id;
    }

    public boolean containsId(Object item) {
        boolean b2 = this.map.containsKey(new IdWrapper(item));
        return b2;
    }

    public void removeId(Object item) {
        this.map.remove(new IdWrapper(item));
        this.cleanup();
    }

    public int size() {
        this.cleanup();
        return this.map.size();
    }

    private void cleanup() {
        WeakIdWrapper wrapper;
        while ((wrapper = (WeakIdWrapper)this.queue.poll()) != null) {
            this.map.remove(wrapper);
        }
    }

    private class WeakIdWrapper
    extends WeakReference
    implements Wrapper {
        private final int hashCode;

        public WeakIdWrapper(Object obj2) {
            super(obj2, ObjectIdDictionary.this.queue);
            this.hashCode = System.identityHashCode(obj2);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return this.get() == ((Wrapper)other).get();
        }

        public String toString() {
            Object obj2 = this.get();
            return obj2 == null ? "(null)" : obj2.toString();
        }
    }

    private static class IdWrapper
    implements Wrapper {
        private final Object obj;
        private final int hashCode;

        public IdWrapper(Object obj2) {
            this.hashCode = System.identityHashCode(obj2);
            this.obj = obj2;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            return this.obj == ((Wrapper)other).get();
        }

        public String toString() {
            return this.obj.toString();
        }

        public Object get() {
            return this.obj;
        }
    }

    private static interface Wrapper {
        public int hashCode();

        public boolean equals(Object var1);

        public String toString();

        public Object get();
    }
}

