/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Fields {
    public static Field locate(Class definedIn, Class fieldType, boolean isStatic) {
        AccessibleObject field = null;
        try {
            Field[] fields = definedIn.getDeclaredFields();
            for (int i2 = 0; i2 < fields.length; ++i2) {
                if (Modifier.isStatic(fields[i2].getModifiers()) != isStatic || !fieldType.isAssignableFrom(fields[i2].getType())) continue;
                field = fields[i2];
            }
            if (field != null && !field.isAccessible()) {
                ((Field)field).setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return field;
    }

    public static Field find(Class type2, String name2) {
        try {
            Field result2 = type2.getDeclaredField(name2);
            if (!result2.isAccessible()) {
                result2.setAccessible(true);
            }
            return result2;
        }
        catch (SecurityException e2) {
            throw Fields.wrap("Cannot access field", type2, name2, e2);
        }
        catch (NoSuchFieldException e3) {
            throw Fields.wrap("Cannot access field", type2, name2, e3);
        }
        catch (NoClassDefFoundError e4) {
            throw Fields.wrap("Cannot access field", type2, name2, e4);
        }
    }

    public static void write(Field field, Object instance, Object value2) {
        try {
            field.set(instance, value2);
        }
        catch (SecurityException e2) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e2);
        }
        catch (IllegalArgumentException e3) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e3);
        }
        catch (IllegalAccessException e4) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e4);
        }
        catch (NoClassDefFoundError e5) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e5);
        }
    }

    public static Object read(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (SecurityException e2) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e2);
        }
        catch (IllegalArgumentException e3) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e3);
        }
        catch (IllegalAccessException e4) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e4);
        }
        catch (NoClassDefFoundError e5) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e5);
        }
    }

    private static ObjectAccessException wrap(String message2, Class type2, String name2, Throwable ex) {
        ObjectAccessException exception = new ObjectAccessException(message2, ex);
        exception.add("field", type2.getName() + "." + name2);
        return exception;
    }
}

