/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

public final class FastStack {
    private Object[] stack;
    private int pointer;

    public FastStack(int initialCapacity) {
        this.stack = new Object[initialCapacity];
    }

    public Object push(Object value2) {
        if (this.pointer + 1 >= this.stack.length) {
            this.resizeStack(this.stack.length * 2);
        }
        this.stack[this.pointer++] = value2;
        return value2;
    }

    public void popSilently() {
        this.stack[--this.pointer] = null;
    }

    public Object pop() {
        Object result2 = this.stack[--this.pointer];
        this.stack[this.pointer] = null;
        return result2;
    }

    public Object peek() {
        return this.pointer == 0 ? null : this.stack[this.pointer - 1];
    }

    public Object replace(Object value2) {
        Object result2 = this.stack[this.pointer - 1];
        this.stack[this.pointer - 1] = value2;
        return result2;
    }

    public void replaceSilently(Object value2) {
        this.stack[this.pointer - 1] = value2;
    }

    public int size() {
        return this.pointer;
    }

    public boolean hasStuff() {
        return this.pointer > 0;
    }

    public Object get(int i2) {
        return this.stack[i2];
    }

    private void resizeStack(int newCapacity) {
        Object[] newStack = new Object[newCapacity];
        System.arraycopy(this.stack, 0, newStack, 0, Math.min(this.pointer, newCapacity));
        this.stack = newStack;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer("[");
        for (int i2 = 0; i2 < this.pointer; ++i2) {
            if (i2 > 0) {
                result2.append(", ");
            }
            result2.append(this.stack[i2]);
        }
        result2.append(']');
        return result2.toString();
    }
}

