/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.ErrorReporter;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.core.util.PrioritizedList;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.AbstractSecurityException;
import java.util.Collections;
import java.util.Iterator;

public class TreeUnmarshaller
implements UnmarshallingContext {
    private Object root;
    protected HierarchicalStreamReader reader;
    private ConverterLookup converterLookup;
    private Mapper mapper;
    private FastStack types = new FastStack(16);
    private DataHolder dataHolder;
    private final PrioritizedList validationList = new PrioritizedList();

    public TreeUnmarshaller(Object root2, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
        this.root = root2;
        this.reader = reader;
        this.converterLookup = converterLookup;
        this.mapper = mapper;
    }

    public Object convertAnother(Object parent2, Class type2) {
        return this.convertAnother(parent2, type2, null);
    }

    public Object convertAnother(Object parent2, Class type2, Converter converter) {
        type2 = this.mapper.defaultImplementationOf(type2);
        if (converter == null) {
            converter = this.converterLookup.lookupConverterForType(type2);
        } else if (!converter.canConvert(type2)) {
            ConversionException e2 = new ConversionException("Explicit selected converter cannot handle type");
            e2.add("item-type", type2.getName());
            e2.add("converter-type", converter.getClass().getName());
            throw e2;
        }
        return this.convert(parent2, type2, converter);
    }

    protected Object convert(Object parent2, Class type2, Converter converter) {
        this.types.push(type2);
        try {
            Object object = converter.unmarshal(this.reader, this);
            return object;
        }
        catch (ConversionException conversionException) {
            this.addInformationTo(conversionException, type2, converter, parent2);
            throw conversionException;
        }
        catch (AbstractSecurityException e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            ConversionException conversionException = new ConversionException(e3);
            this.addInformationTo(conversionException, type2, converter, parent2);
            throw conversionException;
        }
        finally {
            this.types.popSilently();
        }
    }

    private void addInformationTo(ErrorWriter errorWriter, Class type2, Converter converter, Object parent2) {
        errorWriter.add("class", type2.getName());
        errorWriter.add("required-type", this.getRequiredType().getName());
        errorWriter.add("converter-type", converter.getClass().getName());
        if (converter instanceof ErrorReporter) {
            ((ErrorReporter)((Object)converter)).appendErrors(errorWriter);
        }
        if (parent2 instanceof ErrorReporter) {
            ((ErrorReporter)parent2).appendErrors(errorWriter);
        }
        this.reader.appendErrors(errorWriter);
    }

    public void addCompletionCallback(Runnable work, int priority) {
        this.validationList.add(work, priority);
    }

    public Object currentObject() {
        return this.types.size() == 1 ? this.root : null;
    }

    public Class getRequiredType() {
        return (Class)this.types.peek();
    }

    public Object get(Object key2) {
        return this.dataHolder != null ? this.dataHolder.get(key2) : null;
    }

    public void put(Object key2, Object value2) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(key2, value2);
    }

    public Iterator keys() {
        return this.dataHolder != null ? this.dataHolder.keys() : Collections.EMPTY_MAP.keySet().iterator();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    public Object start(DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        Class type2 = HierarchicalStreams.readClassType(this.reader, this.mapper);
        Object result2 = this.convertAnother(null, type2);
        Iterator validations = this.validationList.iterator();
        while (validations.hasNext()) {
            Runnable runnable = (Runnable)validations.next();
            runnable.run();
        }
        return result2;
    }

    protected Mapper getMapper() {
        return this.mapper;
    }
}

