/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class SunLimitedUnsafeReflectionProvider
extends PureJavaReflectionProvider {
    protected static final Unsafe unsafe;
    protected static final Exception exception;

    public SunLimitedUnsafeReflectionProvider() {
    }

    public SunLimitedUnsafeReflectionProvider(FieldDictionary fieldDictionary) {
        super(fieldDictionary);
    }

    public Object newInstance(Class type2) {
        if (exception != null) {
            ObjectAccessException ex = new ObjectAccessException("Cannot construct type", exception);
            ex.add("construction-type", type2.getName());
            throw ex;
        }
        ErrorWritingException ex = null;
        if (type2 == Void.TYPE || type2 == Void.class) {
            ex = new ConversionException("Security alert: Marshalling rejected");
        } else {
            try {
                return unsafe.allocateInstance(type2);
            }
            catch (SecurityException e2) {
                ex = new ObjectAccessException("Cannot construct type", e2);
            }
            catch (InstantiationException e3) {
                ex = new ConversionException("Cannot construct type", e3);
            }
            catch (IllegalArgumentException e4) {
                ex = new ObjectAccessException("Cannot construct type", e4);
            }
        }
        ex.add("construction-type", type2.getName());
        throw ex;
    }

    protected void validateFieldAccess(Field field) {
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    static {
        Unsafe u = null;
        Exception ex = null;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            u = (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e2) {
            ex = e2;
        }
        catch (NoSuchFieldException e3) {
            ex = e3;
        }
        catch (IllegalArgumentException e4) {
            ex = e4;
        }
        catch (IllegalAccessException e5) {
            ex = e5;
        }
        exception = ex;
        unsafe = u;
    }
}

