/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.reflection.FieldKey;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class SortableFieldKeySorter
implements FieldKeySorter,
Caching {
    private static final FieldKey[] EMPTY_FIELD_KEY_ARRAY = new FieldKey[0];
    private final Map map = new HashMap();

    public Map sort(Class type2, Map keyedByFieldKey) {
        if (this.map.containsKey(type2)) {
            OrderRetainingMap result2 = new OrderRetainingMap();
            FieldKey[] fieldKeys = keyedByFieldKey.keySet().toArray(EMPTY_FIELD_KEY_ARRAY);
            Arrays.sort(fieldKeys, (Comparator)this.map.get(type2));
            for (int i2 = 0; i2 < fieldKeys.length; ++i2) {
                result2.put(fieldKeys[i2], keyedByFieldKey.get(fieldKeys[i2]));
            }
            return result2;
        }
        return keyedByFieldKey;
    }

    public void registerFieldOrder(Class type2, String[] fields) {
        this.map.put(type2, new FieldComparator(type2, fields));
    }

    public void flushCache() {
        this.map.clear();
    }

    private class FieldComparator
    implements Comparator {
        private final String[] fieldOrder;
        private final Class type;

        public FieldComparator(Class type2, String[] fields) {
            this.type = type2;
            this.fieldOrder = fields;
        }

        public int compare(String first2, String second) {
            int firstPosition = -1;
            int secondPosition = -1;
            for (int i2 = 0; i2 < this.fieldOrder.length; ++i2) {
                if (this.fieldOrder[i2].equals(first2)) {
                    firstPosition = i2;
                }
                if (!this.fieldOrder[i2].equals(second)) continue;
                secondPosition = i2;
            }
            if (firstPosition == -1 || secondPosition == -1) {
                ConversionException exception = new ConversionException("Incomplete list of serialized fields for type");
                exception.add("sort-type", this.type.getName());
                throw exception;
            }
            return firstPosition - secondPosition;
        }

        public int compare(Object firstObject, Object secondObject) {
            FieldKey first2 = (FieldKey)firstObject;
            FieldKey second = (FieldKey)secondObject;
            return this.compare(first2.getFieldName(), second.getFieldName());
        }
    }
}

