/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicReferenceConverter
implements Converter {
    private Mapper mapper;

    public AtomicReferenceConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type2) {
        return type2 != null && type2 == AtomicReference.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        AtomicReference ref2 = (AtomicReference)source;
        writer.startNode(this.mapper.serializedMember(AtomicReference.class, "value"));
        Object object = ref2.get();
        String name2 = this.mapper.serializedClass(object != null ? object.getClass() : null);
        writer.addAttribute(this.mapper.aliasForSystemAttribute("class"), name2);
        context.convertAnother(ref2.get());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        Class type2 = HierarchicalStreams.readClassType(reader, this.mapper);
        Object value2 = context.convertAnother(context, type2);
        reader.moveUp();
        return new AtomicReference<Object>(value2);
    }
}

