/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.InitializationException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumToStringConverter<T extends Enum<T>>
extends AbstractSingleValueConverter {
    private final Class<T> enumType;
    private final Map<String, T> strings;
    private final EnumMap<T, String> values;

    public EnumToStringConverter(Class<T> type2) {
        this(type2, EnumToStringConverter.extractStringMap(type2), null);
    }

    public EnumToStringConverter(Class<T> type2, Map<String, T> strings) {
        this(type2, strings, EnumToStringConverter.buildValueMap(type2, strings));
    }

    private EnumToStringConverter(Class<T> type2, Map<String, T> strings, EnumMap<T, String> values2) {
        this.enumType = type2;
        this.strings = strings;
        this.values = values2;
    }

    private static <T extends Enum<T>> Map<String, T> extractStringMap(Class<T> type2) {
        EnumToStringConverter.checkType(type2);
        EnumSet<Enum> values2 = EnumSet.allOf(type2);
        HashMap<String, Enum> strings = new HashMap<String, Enum>(values2.size());
        for (Enum value2 : values2) {
            if (strings.put(value2.toString(), value2) == null) continue;
            throw new InitializationException("Enum type " + type2.getName() + " does not have unique string representations for its values");
        }
        return strings;
    }

    private static <T> void checkType(Class<T> type2) {
        if (!Enum.class.isAssignableFrom(type2) && type2 != Enum.class) {
            throw new InitializationException("Converter can only handle enum types");
        }
    }

    private static <T extends Enum<T>> EnumMap<T, String> buildValueMap(Class<T> type2, Map<String, T> strings) {
        EnumMap<T, String> values2 = new EnumMap<T, String>(type2);
        for (Map.Entry<String, T> entry : strings.entrySet()) {
            values2.put((Enum)entry.getValue(), entry.getKey());
        }
        return values2;
    }

    @Override
    public boolean canConvert(Class type2) {
        return type2 != null && this.enumType.isAssignableFrom(type2);
    }

    @Override
    public String toString(Object obj2) {
        Enum value2 = (Enum)Enum.class.cast(obj2);
        return this.values == null ? value2.toString() : this.values.get(value2);
    }

    @Override
    public Object fromString(String str) {
        if (str == null) {
            return null;
        }
        Enum result2 = (Enum)this.strings.get(str);
        if (result2 == null) {
            ConversionException exception = new ConversionException("Invalid string representation for enum type");
            exception.add("enum-type", this.enumType.getName());
            exception.add("enum-string", str);
            throw exception;
        }
        return result2;
    }
}

