/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.smartenter;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class SqlPlainEnterProcessor
extends SmartEnterProcessorWithFixers.FixEnterProcessor {
    static SqlStatement getStatement(Editor editor2, PsiFile psiFile) {
        IElementType type2;
        PsiElement currElement;
        int offset = editor2.getCaretModel().getOffset();
        if (offset > 0 && offset == editor2.getDocument().getTextLength()) {
            --offset;
        }
        if ((currElement = psiFile.findElementAt(offset)) != null && (SqlTokens.SQL_WHITE_SPACE == (type2 = currElement.getNode().getElementType()) || SqlCommonTokens.SQL_SEMICOLON == type2)) {
            currElement = PsiTreeUtil.prevVisibleLeaf((PsiElement)currElement);
        }
        return (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)currElement, SqlStatement.class);
    }

    public boolean doEnter(PsiElement atCaret, PsiFile file, @NotNull Editor editor2, boolean modified) {
        if (editor2 == null) {
            SqlPlainEnterProcessor.$$$reportNull$$$0(0);
        }
        if (!modified) {
            return false;
        }
        SqlStatement statement2 = SqlPlainEnterProcessor.getStatement(editor2, file);
        if (statement2 != null) {
            int textLength = editor2.getDocument().getTextLength();
            int offset = statement2.getTextRange().getEndOffset() + 1;
            int move = Math.min(offset, textLength);
            editor2.getCaretModel().moveToOffset(move);
            this.plainEnter(editor2);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/smartenter/SqlPlainEnterProcessor", "doEnter"));
    }
}

