/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase;
import com.intellij.sql.refactoring.SqlIntroduceHandlerBase$smartChooseExpression$;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\n\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000b\u001a\u00020\fH$\u00a2\u0006\u0002\u0010\rJ+\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0086\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H$J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0086\u0002\u00a2\u0006\u0002\u0010\u001dJ \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\u001cH\u0002J\"\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010#\u001a\u00020\u0006H\u0004J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J-\u0010%\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020&2\u0006\u0010'\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010(R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006)"}, d2={"Lcom/intellij/sql/refactoring/SqlIntroduceHandlerBase;", "Helper", "Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "Lcom/intellij/lang/ContextAwareActionHandler;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getHelper", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "(Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)Lcom/intellij/sql/refactoring/SqlIntroduceHelper;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableForQuickList", "", "isCalleeExpression", "e", "showError", "message", "showNoContainerError", "smartChooseExpression", "Lcom/intellij/sql/psi/SqlFile;", "helper", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/sql/psi/SqlFile;Lcom/intellij/sql/refactoring/SqlIntroduceHelper;)V", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlIntroduceHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlIntroduceHandlerBase.kt\ncom/intellij/sql/refactoring/SqlIntroduceHandlerBase\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,107:1\n473#2:108\n*S KotlinDebug\n*F\n+ 1 SqlIntroduceHandlerBase.kt\ncom/intellij/sql/refactoring/SqlIntroduceHandlerBase\n*L\n90#1:108\n*E\n"})
public abstract class SqlIntroduceHandlerBase<Helper extends SqlIntroduceHelper>
implements RefactoringActionHandler,
ContextAwareActionHandler {
    @NotNull
    private final String name;

    public SqlIntroduceHandlerBase(@Nls @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        this.name = name2;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor2, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return file instanceof SqlFile;
    }

    @Nullable
    protected abstract Helper getHelper(@NotNull SqlLanguageDialectEx var1);

    protected abstract void invoke(@NotNull Project var1, @NotNull Editor var2, @NotNull SqlExpression var3);

    protected final void showError(@NotNull Project project, @NotNull Editor editor2, @NlsContexts.DialogMessage @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)message2, (String)SqlBundle.message((String)"dialog.title.cannot.perform.refactoring", (Object[])new Object[0]), null);
    }

    public final void invoke(@NotNull Project project, @NotNull PsiElement[] elements2, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)((PsiElement)file))) {
            return;
        }
        if (!(file instanceof SqlFile)) {
            return;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Helper helper = this.getHelper(dialect);
        if (helper == null) {
            Object[] objectArray = new Object[]{this.name, dialect.getDisplayName()};
            String string = SqlBundle.message((String)"dialog.message.not.supported.for", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showError(project, editor2, string);
            return;
        }
        SelectionModel selectionModel = editor2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            SqlExpression expression = SqlImplUtil.getElementBySelection(file, selectionModel2.getSelectionStart(), selectionModel2.getSelectionEnd(), SqlExpression.class);
            if (expression == null) {
                String string = SqlBundle.message((String)"dialog.message.selected.fragment.must.be.valid.expression", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                this.showError(project, editor2, string);
                return;
            }
            if (helper.findTopmostBlock((PsiElement)expression) == null) {
                this.showNoContainerError(project, editor2);
                return;
            }
            this.invoke(project, editor2, expression);
        } else {
            this.smartChooseExpression(project, editor2, (SqlFile)file, helper);
        }
    }

    private final void showNoContainerError(Project project, Editor editor2) {
        Object[] objectArray = new Object[]{this.name};
        String string = SqlBundle.message((String)"dialog.message.not.available.in.this.context", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.showError(project, editor2, string);
    }

    private final boolean isCalleeExpression(PsiElement e2) {
        return e2 instanceof SqlReferenceExpression && ((SqlReferenceExpression)e2).getReferenceElementType() == SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE;
    }

    private final void smartChooseExpression(Project project, Editor editor2, SqlFile file, Helper helper) {
        Sequence parents2;
        int offset = editor2.getCaretModel().getOffset();
        PsiElement currentElement = file.findElementAt(offset);
        if (helper.findTopmostBlock(currentElement) == null) {
            this.showNoContainerError(project, editor2);
            return;
        }
        Sequence $this$filterIsInstance$iv = parents2 = SequencesKt.generateSequence((Object)currentElement, (Function1)smartChooseExpression.parents.1.INSTANCE);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)smartChooseExpression$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List expressions2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, (Function1)((Function1)new Function1<SqlExpression, Boolean>(this){
            final /* synthetic */ SqlIntroduceHandlerBase<Helper> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                return !SqlIntroduceHandlerBase.access$isCalleeExpression(this.this$0, (PsiElement)it2);
            }
        })));
        if (expressions2.isEmpty()) {
            String string = SqlBundle.message((String)"dialog.message.no.valid.expressions.were.found", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.showError(project, editor2, string);
        } else if (expressions2.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.invoke(project, editor2, (SqlExpression)CollectionsKt.first((List)expressions2));
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor2, (List)expressions2, (Pass)((Pass)new Pass<SqlExpression>(this, project, editor2){
                final /* synthetic */ SqlIntroduceHandlerBase<Helper> this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ Editor $editor;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                    this.$editor = $editor;
                }

                public void pass(@NotNull SqlExpression expression) {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    this.this$0.invoke(this.$project, this.$editor, expression);
                }
            }), arg_0 -> SqlIntroduceHandlerBase.smartChooseExpression$lambda$0(smartChooseExpression.2.INSTANCE, arg_0));
        }
    }

    private static final String smartChooseExpression$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$isCalleeExpression(SqlIntroduceHandlerBase $this, PsiElement e2) {
        return $this.isCalleeExpression(e2);
    }
}

