/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlTriggerDefinitionElementType;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class SqlTriggerStub
extends SqlDefinitionStub<SqlCreateTriggerStatement> {
    protected final StringRef myTableName;
    protected final StringRef myTriggerProcText;
    private SqlReferenceExpression myTargetReference;
    private SqlExpression myTriggerProcedure;

    public SqlTriggerStub(StubElement parent2, @NotNull SqlTriggerDefinitionElementType elementType, StringRef name2, @NotNull SqlDefinitionStub.ModelInfo info2, StringRef tableName, StringRef triggerProcText) {
        if (elementType == null) {
            SqlTriggerStub.$$$reportNull$$$0(0);
        }
        if (info2 == null) {
            SqlTriggerStub.$$$reportNull$$$0(1);
        }
        super(parent2, elementType, name2, info2);
        this.myTableName = tableName;
        this.myTriggerProcText = triggerProcText;
    }

    public String getTableName() {
        return this.myTableName == null ? null : this.myTableName.getString();
    }

    public String getTriggerProcText() {
        return this.myTriggerProcText == null ? null : this.myTriggerProcText.getString();
    }

    public SqlReferenceExpression getTableReference() {
        if (this.myTargetReference == null) {
            String targetName = this.getTableName();
            if (targetName == null) {
                return null;
            }
            this.myTargetReference = this.createReference(SqlCompositeElementTypes.SQL_TABLE_REFERENCE, targetName);
        }
        return this.myTargetReference;
    }

    public SqlExpression getTriggerProcedure() {
        if (this.myTriggerProcedure == null && this.myTriggerProcText != null) {
            String exprText = this.getTriggerProcText();
            if (exprText == null) {
                return null;
            }
            SqlCreateTriggerStatement psi = (SqlCreateTriggerStatement)this.getPsi();
            this.myTriggerProcedure = SqlPsiElementFactory.createExpressionFromText(exprText, SqlImplUtil.getSqlDialectSafe((PsiElement)psi), (PsiElement)psi);
        }
        return this.myTriggerProcedure;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "elementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/psi/stubs/SqlTriggerStub";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

