/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.sql.psi.stubs.SqlTableElementType;
import com.intellij.util.io.StringRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlTableStub
extends SqlDefinitionStub<SqlTableDefinition> {
    private final StringRef myExpressionText;
    private final StringRef[][] myAncestorTextRefs;
    private SqlExpression myExpression;
    private final List<SqlReferenceExpression>[] myAncestorRefs;

    protected SqlTableStub(StubElement parent2, @NotNull SqlTableElementType elementType, StringRef name2, @NotNull SqlDefinitionStub.ModelInfo info2, StringRef expressionText, StringRef[][] ancestorRefs) {
        if (elementType == null) {
            SqlTableStub.$$$reportNull$$$0(0);
        }
        if (info2 == null) {
            SqlTableStub.$$$reportNull$$$0(1);
        }
        super(parent2, elementType, name2, info2);
        this.myExpressionText = expressionText;
        this.myAncestorTextRefs = ancestorRefs;
        this.myAncestorRefs = ancestorRefs == null ? null : new List[ancestorRefs.length];
    }

    public String getExpressionText() {
        return this.myExpressionText == null ? null : this.myExpressionText.getString();
    }

    public StringRef[][] getAncestorTextRefs() {
        return this.myAncestorTextRefs;
    }

    public SqlExpression getQueryExpression() {
        String text2;
        if (this.myExpression == null && StringUtil.isNotEmpty((String)(text2 = this.getExpressionText()))) {
            SqlTableDefinition psi = (SqlTableDefinition)this.getPsi();
            this.myExpression = SqlPsiElementFactory.createQueryExpressionFromText(text2, (SqlLanguageDialect)SqlImplUtil.getSqlDialectSafe((PsiElement)psi), (PsiElement)psi);
        }
        return this.myExpression;
    }

    @NotNull
    public List<SqlReferenceExpression> getAncestorRefs(int idx) {
        if (this.myAncestorRefs == null || idx < 0 || idx >= this.myAncestorRefs.length) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlTableStub.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (this.myAncestorRefs[idx] == null) {
            StringRef[] refs = this.myAncestorTextRefs[idx];
            SqlTableDefinition psi = (SqlTableDefinition)this.getPsi();
            SqlReferenceExpression[] parsed = new SqlReferenceExpression[refs.length];
            for (int i2 = 0; i2 < refs.length; ++i2) {
                parsed[i2] = SqlPsiElementFactory.createReferenceFromText(refs[i2].getString(), SqlImplUtil.getSqlDialectSafe((PsiElement)psi), SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (PsiElement)psi);
            }
            this.myAncestorRefs[idx] = Arrays.asList(parsed);
        }
        List<SqlReferenceExpression> list = this.myAncestorRefs[idx];
        if (list == null) {
            SqlTableStub.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlTableStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlTableStub";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAncestorRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

