/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.parser.SqlParserDefinition;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlStubElementType<S extends StubElement<T>, T extends SqlElement>
extends IStubElementType<S, T> {
    public SqlStubElementType(@NonNls @NotNull String debugName) {
        if (debugName == null) {
            SqlStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, (Language)SqlLanguage.INSTANCE);
    }

    public void indexStub(@NotNull S stub, @NotNull IndexSink sink) {
        if (stub == null) {
            SqlStubElementType.$$$reportNull$$$0(1);
        }
        if (sink == null) {
            SqlStubElementType.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public String getExternalId() {
        String string = "sql." + super.toString();
        if (string == null) {
            SqlStubElementType.$$$reportNull$$$0(3);
        }
        return string;
    }

    public T createPsi(@NotNull S stub) {
        if (stub == null) {
            SqlStubElementType.$$$reportNull$$$0(4);
        }
        SqlFileImpl file = (SqlFileImpl)stub.getParentStubOfType(SqlFileImpl.class);
        assert (file != null);
        SqlLanguageDialectEx dialect = file.getSqlLanguage();
        SqlParserDefinition definition2 = (SqlParserDefinition)((Object)LanguageParserDefinitions.INSTANCE.forLanguage((Language)dialect));
        return (T)((SqlElement)definition2.createElement(stub));
    }

    @Nullable
    protected static StringRef asStringRef(PsiElement nameElement) {
        String text2 = nameElement == null ? null : nameElement.getText();
        return text2 == null ? null : StringRef.fromString((String)text2);
    }

    public boolean shouldCreateStub(ASTNode node2) {
        return super.shouldCreateStub(node2) && !SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(node2.getTreeParent().getElementType());
    }

    protected static <T extends SqlNamedElementStub<? extends SqlDefinition>> void indexNamedStub(T stub, StubIndexKey<String, SqlDefinition> key2, IndexSink sink) {
        String shortName;
        String name2 = stub.getName();
        String string = shortName = name2 == null ? null : StringUtil.getShortName((String)name2);
        if (shortName == null || shortName.length() == 0) {
            return;
        }
        char c2 = shortName.charAt(0);
        String nameToIndex = shortName.length() > 2 && (c2 == '\'' || c2 == '\"' || c2 == '`' || c2 == '[') ? shortName.substring(1, shortName.length() - 2) : shortName;
        sink.occurrence(key2, (Object)nameToIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlStubElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlStubElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

