/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.model.ObjectKind;
import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.stubs.SqlDefinitionStubElementType;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlStubElementType;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlNamedStubElementType<S extends SqlNamedElementStub<T>, T extends SqlElement>
extends SqlStubElementType<S, T> {
    protected final SqlReferenceElementType myType;

    public SqlNamedStubElementType(@NonNls @NotNull String debugName, @Nullable SqlReferenceElementType refType) {
        if (debugName == null) {
            SqlNamedStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName);
        this.myType = refType;
    }

    @Nullable
    public SqlReferenceElementType getTargetReferenceType() {
        return this.myType;
    }

    public void serialize(@NotNull S stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            SqlNamedStubElementType.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            SqlNamedStubElementType.$$$reportNull$$$0(2);
        }
        dataStream.writeName(((SqlNamedElementStub)((Object)stub)).getName());
    }

    @Override
    public boolean shouldCreateStub(ASTNode node2) {
        if (this == SqlCompositeElementTypes.SQL_RETURNS_CLAUSE) {
            ASTNode parent2 = node2.getTreeParent();
            IElementType pType = PsiUtilCore.getElementType((ASTNode)parent2);
            return pType instanceof IStubElementType && ((IStubElementType)pType).shouldCreateStub(parent2);
        }
        if (this == SqlCompositeElementTypes.SQL_TYPE_DEFINITION || this == SqlCompositeElementTypes.SQL_ALIAS_TYPE_DEFINITION || this == SqlCompositeElementTypes.SQL_COLLECTION_TYPE_DEFINITION) {
            ASTNode parent3 = SqlNamedStubElementType.getSqlParent(node2);
            IElementType elementType = PsiUtilCore.getElementType((ASTNode)parent3);
            ObjectKind pKind = SqlNamedStubElementType.getDefKind(parent3);
            return pKind != ObjectKind.BODY && pKind != ObjectKind.ROUTINE && pKind != null && elementType != SqlCompositeElementTypes.SQL_BLOCK_STATEMENT;
        }
        if (this.myType == null) {
            return false;
        }
        if (this.myType.getTargetKind() == ObjectKind.EXCEPTION) {
            return SqlNamedStubElementType.getDefKind(SqlNamedStubElementType.getSqlParent(node2)) == ObjectKind.PACKAGE;
        }
        if (this.myType.getTargetKind() == ObjectKind.ARGUMENT) {
            ASTNode parent4 = SqlNamedStubElementType.getSqlParent(node2);
            ASTNode gParent = SqlNamedStubElementType.getSqlParent(parent4);
            IElementType gpType = PsiUtilCore.getElementType((ASTNode)gParent);
            return PsiUtilCore.getElementType((ASTNode)parent4) == SqlCompositeElementTypes.SQL_PARAMETER_LIST && gpType instanceof IStubElementType && ((IStubElementType)gpType).shouldCreateStub(gParent);
        }
        if (this.myType.getTargetKind() == SqlDbElementType.CURSOR) {
            return false;
        }
        if (this.myType.getTargetKind() == ObjectKind.VARIABLE) {
            ASTNode stubParent = SqlNamedStubElementType.getSqlStubParent(node2);
            ObjectKind pKind = SqlNamedStubElementType.getDefKind(stubParent);
            if (pKind != null) {
                return pKind == ObjectKind.PACKAGE && SqlNamedStubElementType.shouldCreateStubFor(stubParent);
            }
            return false;
        }
        if (this.isInType(node2)) {
            return false;
        }
        ASTNode parent5 = SqlNamedStubElementType.getSqlParent(node2);
        SqlDefinitionStubElementType pType = (SqlDefinitionStubElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((ASTNode)parent5), SqlDefinitionStubElementType.class));
        if (pType != null) {
            return pType.shouldCreateStub(parent5);
        }
        return true;
    }

    protected boolean isInType(ASTNode node2) {
        ASTNode p2 = SqlNamedStubElementType.getSqlParent(node2);
        IElementType pType = PsiUtilCore.getElementType((ASTNode)p2);
        if (SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(pType)) {
            return true;
        }
        if (pType != SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST) {
            return false;
        }
        ASTNode gp = SqlNamedStubElementType.getSqlParent(p2);
        return SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(PsiUtilCore.getElementType((ASTNode)gp));
    }

    @Nullable
    private static ObjectKind getDefKind(ASTNode node2) {
        return SqlNamedStubElementType.getDefKind(PsiUtilCore.getElementType((ASTNode)node2));
    }

    @Nullable
    private static ObjectKind getDefKind(IElementType elementType) {
        SqlDefinitionStubElementType type2 = (SqlDefinitionStubElementType)((Object)ObjectUtils.tryCast((Object)elementType, SqlDefinitionStubElementType.class));
        SqlReferenceElementType refType = type2 == null ? null : type2.getTargetReferenceType();
        return refType == null ? null : refType.getTargetKind();
    }

    private static boolean shouldCreateStubFor(ASTNode node2) {
        IElementType type2 = PsiUtilCore.getElementType((ASTNode)node2);
        return type2 instanceof IStubElementType && ((IStubElementType)type2).shouldCreateStub(node2);
    }

    @Nullable
    protected static ASTNode getSqlParent(@Nullable ASTNode node2) {
        ASTNode aSTNode = node2 = node2 == null ? null : node2.getTreeParent();
        while (node2 != null && node2.getElementType() == SqlElementTypes.SQL_DUMMY_BLOCK) {
            node2 = node2.getTreeParent();
        }
        return node2;
    }

    @Nullable
    protected static ASTNode getSqlStubParent(@Nullable ASTNode node2) {
        ASTNode aSTNode = node2 = node2 == null ? null : node2.getTreeParent();
        while (node2 != null) {
            if (PsiUtilCore.getElementType((ASTNode)node2) instanceof IStubElementType) {
                return node2;
            }
            node2 = node2.getTreeParent();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/psi/stubs/SqlNamedStubElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "serialize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

