/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.sql.psi.impl.lexer.SqlStringTokenLexer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringLiteralEscaper
extends LiteralTextEscaper<SqlStringLiteralExpression> {
    private int[] outSourceOffsets;

    public SqlStringLiteralEscaper(SqlStringLiteralExpression element2) {
        super((PsiLanguageInjectionHost)element2);
    }

    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(1);
        }
        SqlStringLiteralManipulator.LiteralType type2 = SqlStringLiteralManipulator.getStringLiteralType((PsiElement)this.myHost);
        String text2 = ((SqlStringLiteralExpression)this.myHost).getText();
        int r0 = rangeInsideHost.getStartOffset();
        int r1 = rangeInsideHost.getEndOffset();
        if (type2 == SqlStringLiteralManipulator.LiteralType.QUOTED) {
            this.outSourceOffsets = new int[rangeInsideHost.getLength() + 1];
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)this.myHost).getDbms();
            SqlStringLiteralEscaper.decode(text2, r0, r1, outChars, this.outSourceOffsets, dbms);
        } else {
            this.outSourceOffsets = null;
            outChars.append(text2, rangeInsideHost.getStartOffset(), rangeInsideHost.getEndOffset());
        }
        return true;
    }

    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        if (rangeInsideHost == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(2);
        }
        SqlStringLiteralManipulator.LiteralType type2 = SqlStringLiteralManipulator.getStringLiteralType((PsiElement)this.myHost);
        int offset = offsetInDecoded;
        if (type2 == SqlStringLiteralManipulator.LiteralType.QUOTED && this.outSourceOffsets != null) {
            int result2;
            int n = result2 = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
            if (result2 == -1) {
                return -1;
            }
            return Math.min(result2, rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
        }
        if ((offset += rangeInsideHost.getStartOffset()) < rangeInsideHost.getStartOffset()) {
            offset = rangeInsideHost.getStartOffset();
        }
        if (offset > rangeInsideHost.getEndOffset()) {
            offset = rangeInsideHost.getEndOffset();
        }
        return offset;
    }

    @NotNull
    public TextRange getRelevantTextRange() {
        TextRange textRange = SqlStringLiteralManipulator.getStringContentRange((PsiElement)this.myHost);
        if (textRange == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    public boolean isOneLine() {
        return SqlStringLiteralManipulator.getStringLiteralType((PsiElement)this.myHost) != SqlStringLiteralManipulator.LiteralType.QUOTED;
    }

    public static boolean supportsSlashEscapes(@NotNull SqlStringTokenElement element2, @NotNull String text2) {
        SqlLanguageDialectEx dialect;
        Dbms dbms;
        if (element2 == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(5);
        }
        return (dbms = (dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element2)).getDbms()).isMysql() || dbms.isPostgres() && StringUtil.startsWithIgnoreCase((String)text2, (String)"e");
    }

    public static void decode(@NotNull CharSequence text2, int start2, int end, @NotNull StringBuilder outChars, @Nullable int[] outOffsets, @NotNull Dbms dbms) {
        if (text2 == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(6);
        }
        if (outChars == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(7);
        }
        if (dbms == null) {
            SqlStringLiteralEscaper.$$$reportNull$$$0(8);
        }
        SqlStringTokenLexer lexer = new SqlStringTokenLexer(dbms);
        lexer.start(text2, 0, text2.length());
        int pos = 0;
        while (lexer.getTokenType() != null) {
            IElementType type2 = lexer.getTokenType();
            int t0 = lexer.getTokenStart();
            int t1 = lexer.getTokenEnd();
            if (t1 < start2) {
                lexer.advance();
                continue;
            }
            for (int i2 = Math.max(t0, start2); i2 < Math.min(t1, end); ++i2) {
                if (type2 == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) {
                    char esc = text2.charAt(t1 - 1);
                    if (i2 != Math.max(t0, start2)) continue;
                    outChars.append((char)(esc == 'b' ? 8 : (esc == 'n' ? 10 : (esc == 'r' ? 13 : (esc == 't' ? 9 : (esc == 'Z' ? 22 : (esc == '0' ? 0 : (esc == 'f' ? 12 : (int)esc))))))));
                    if (outOffsets == null) continue;
                    outOffsets[pos++] = i2 - start2;
                    continue;
                }
                if (type2 == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) continue;
                outChars.append(text2.charAt(i2));
                if (outOffsets == null) continue;
                outOffsets[pos++] = i2 - start2;
            }
            if (t1 > end) break;
            lexer.advance();
        }
        if (outOffsets != null) {
            outOffsets[pos] = end - start2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlStringLiteralEscaper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlStringLiteralEscaper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelevantTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInHost";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsSlashEscapes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

