/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasCallableType;
import com.intellij.database.types.DasSetofType;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Case;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlScopingExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlExpressionImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallExpressionImpl
extends SqlExpressionImpl
implements SqlFunctionCallExpression,
NavigationItem {
    public SqlFunctionCallExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlFunctionCallExpression((SqlFunctionCallExpression)this);
    }

    @Nullable
    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getCallableExpression(), SqlReferenceExpression.class);
    }

    @Nullable
    public SqlExpression getCallableExpression() {
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
    }

    public SqlExpressionList getParameterList() {
        for (PsiElement c2 = this.getLastChild(); c2 != null; c2 = c2.getPrevSibling()) {
            if (!(c2 instanceof SqlExpressionList)) continue;
            return (SqlExpressionList)c2;
        }
        return null;
    }

    @Nullable
    private BuiltinFunction.Prototype getPrototypeForReturnType() {
        DasSymbol callableSymbol;
        BuiltinFunction.Prototype prototype = SqlFunctionsUtil.chooseTheBestPrototype(this, true);
        SqlReferenceExpression nameElement = this.getNameElement();
        if (prototype == null && nameElement != null && (callableSymbol = nameElement.resolveSymbol()) instanceof BuiltinFunction) {
            BuiltinFunction.Prototype[] prototypes = ((BuiltinFunction)callableSymbol).getPrototypes();
            prototype = prototypes.length == 1 ? prototypes[0] : null;
        }
        return prototype;
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        BuiltinFunction.Prototype prototype = this.getPrototypeForReturnType();
        SqlReferenceExpression nameElement = this.getNameElement();
        if (prototype != null) {
            DasType dasType = SqlFunctionCallExpressionImpl.createBuiltinFunctionReturnType(prototype, nameElement, (PsiElement)this.getParameterList(), (PsiElement)this);
            if (dasType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(1);
            }
            return dasType;
        }
        if (nameElement == null) {
            SqlExpression expression = this.getCallableExpression();
            DasBuiltinType<?> type2 = expression == null ? null : expression.getDasType();
            DasBuiltinType<?> dasBuiltinType = type2 instanceof DasTableType ? type2 : DasTypeSystemBase.UNKNOWN;
            if (dasBuiltinType == null) {
                SqlFunctionCallExpressionImpl.$$$reportNull$$$0(2);
            }
            return dasBuiltinType;
        }
        DasType dasType = SqlFunctionCallExpressionImpl.createFunctionReturnType(nameElement, (PsiElement)this);
        if (dasType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return dasType;
    }

    public static DasType createFunctionReturnType(@Nullable SqlReferenceExpression nameElement, @NotNull PsiElement routineElement) {
        Object target2;
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(4);
        }
        PsiElement resolve2 = nameElement == null ? null : nameElement.getReference().resolve();
        Object object = target2 = resolve2 instanceof DbElement ? ((DbElement)resolve2).getDelegate() : resolve2;
        if (target2 instanceof SqlFileImpl.GroupImpl) {
            target2 = ((SqlFileImpl.GroupImpl)target2).delegates().first();
        }
        if (target2 instanceof DasRoutine) {
            return SqlFunctionCallExpressionImpl.createRoutineType(resolve2, (DasRoutine)target2, false, routineElement);
        }
        if (target2 instanceof SqlCreateTypeStatement) {
            SqlCreateTypeStatement createTypeStatement = (SqlCreateTypeStatement)target2;
            return createTypeStatement.getSelfDasType();
        }
        DasType dasType = target2 instanceof DasUserDefinedType ? ((DasUserDefinedType)target2).getSelfDasType() : (target2 instanceof DasTypedObject ? ((DasTypedObject)target2).getDasType() : DasTypeSystemBase.UNKNOWN);
        dasType = DasTypeUtilsKt.unwrap(dasType);
        return dasType instanceof DasCallableType ? ((DasCallableType)((Object)dasType)).getReturnType() : dasType;
    }

    @Nullable
    private static SqlTableType createReturnTypeForCallWithColumns(@Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params2, @NotNull PsiElement routineElement) {
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(5);
        }
        if (params2 instanceof SqlExpressionList) {
            ArrayList columns2 = new ArrayList();
            if (!SqlFunctionCallExpressionImpl.collectColumnDefs(columns2, params2, SqlColumnDefinition.class)) {
                SqlFunctionCallExpressionImpl.collectColumnDefs(columns2, routineElement, SqlColumnDefinition.class);
            }
            if (!columns2.isEmpty()) {
                return new TableBasedSqlTableTypeImpl(columns2, (PsiElement)ObjectUtils.chooseNotNull((Object)nameElement, (Object)routineElement));
            }
        }
        return null;
    }

    public static DasType createBuiltinFunctionReturnType(@NotNull BuiltinFunction.Prototype prototype, @Nullable SqlReferenceExpression nameElement, @Nullable PsiElement params2, @NotNull PsiElement routineElement) {
        DasType dasType;
        SqlLanguageDialectEx dialect;
        DasType typeFromDialect;
        if (prototype == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(6);
        }
        if (routineElement == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((typeFromDialect = (dialect = SqlImplUtil.getSqlDialectSafe(routineElement)).getTypeSystem().getBuiltinFunctionReturnType(prototype, nameElement, params2, routineElement)) != null) {
            return typeFromDialect;
        }
        BuiltinFunction.Type returnType = prototype.getReturnType();
        if (returnType == SqlFunctionsUtil.UNNEST) {
            List<SqlExpression> cols2;
            List<Object> list = params2 instanceof SqlExpressionList ? ((SqlExpressionList)params2).getExpressionList() : (cols2 = params2 instanceof SqlExpression ? Collections.singletonList((SqlExpression)params2) : null);
            if (nameElement == null || ContainerUtil.isEmpty(cols2)) {
                return SqlTableTypeBase.EMPTY_TABLE;
            }
            if (cols2.size() == 1 && dialect.getDbms().isPostgres()) {
                DasType dasType2 = cols2.get(0).getDasType();
                if (dasType2 instanceof DasArrayType) {
                    DasArrayType arrayType = (DasArrayType)dasType2;
                    dasType2 = arrayType.getComponentType();
                }
                return dasType2;
            }
            StringBuilder builder = new StringBuilder();
            for (SqlExpression col : cols2) {
                if (!builder.isEmpty()) {
                    builder.append(", ");
                }
                builder.append(prototype.getFunction().getName()).append(" ").append(SqlImplUtil.getArrayElement(col.getDasType()).getSpecification());
            }
            String spec2 = dialect.getTypeSystem().getTableTypeSpecification(builder.toString());
            return SqlFunctionCallExpressionImpl.getDasType(routineElement, DasUnresolvedTypeReference.of(DataTypeFactory.of(spec2)));
        }
        DasType dasType3 = dasType = returnType == null ? null : returnType.getDasType();
        if (dasType != null) {
            dasType = SqlImplUtil.rebuildDasType(dasType, dialect, routineElement);
            DataType dataType = dasType.toDataType();
            SqlTableType typeWithColumns = SqlFunctionCallExpressionImpl.createReturnTypeForCallWithColumns(nameElement, params2, routineElement);
            if (typeWithColumns != null) {
                return typeWithColumns;
            }
            if (dasType instanceof DasTableType) {
                DasTableType tableType2 = (DasTableType)dasType;
                if (tableType2.getColumnCount() == 1 && dialect.getDbms().isPostgres()) {
                    return tableType2.getColumnDasType(0);
                }
                return dasType;
            }
            return dasType instanceof DasBuiltinType ? dasType : DasUnresolvedTypeReference.of(dataType);
        }
        if (returnType instanceof BuiltinFunction.ParamType && params2 instanceof SqlExpressionList) {
            int index2 = ((BuiltinFunction.ParamType)returnType).getIndex();
            List parameters2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)params2, SqlCompositeElement.class);
            if (index2 > 0 && index2 <= parameters2.size()) {
                SqlCompositeElement element2 = (SqlCompositeElement)parameters2.get(index2 - 1);
                return SqlFunctionCallExpressionImpl.getParamType((SqlElement)element2);
            }
            if (index2 == 0) {
                return SqlFunctionCallExpressionImpl.getP0Type(dialect, parameters2);
            }
        }
        return DasTypeSystemBase.UNKNOWN;
    }

    @NotNull
    private static DasType getP0Type(SqlLanguageDialectEx dialect, List<SqlCompositeElement> parameters2) {
        DasType curType = DasTypeSystemBase.UNKNOWN;
        for (SqlCompositeElement param : parameters2) {
            DasType type2 = SqlFunctionCallExpressionImpl.getParamType((SqlElement)param);
            if (curType == DasTypeSystemBase.UNKNOWN || DasTypeUtilsKt.is(type2, DasTypeCategory.REAL)) {
                curType = type2;
                continue;
            }
            if (!DasTypeUtilsKt.is(curType, DasTypeCategory.INTEGER)) continue;
            curType = dialect.getTypeSystem().getRealType();
        }
        DasBuiltinType<?> dasBuiltinType = curType;
        if (dasBuiltinType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(8);
        }
        return dasBuiltinType;
    }

    static <T extends DasTypedObject> boolean collectColumnDefs(List<T> columns2, PsiElement container, Class<T> columnClass) {
        ((SyntaxTraverser)SqlImplUtil.sqlTraverser(container).expandAndSkip(o2 -> o2 == container || o2 instanceof SqlClause)).filter(columnClass).addAllTo(columns2);
        return !columns2.isEmpty();
    }

    public static DasType createRoutineType(@NotNull PsiElement resolve2, @NotNull DasRoutine target2, boolean ensureTable, @NotNull PsiElement qualifier) {
        if (resolve2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(9);
        }
        if (target2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(10);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(11);
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(qualifier);
        Dbms dbms = dialect.getDbms();
        DasArgument retArg = target2.getReturnArgument();
        if (dbms.isPostgres()) {
            DataType retType;
            DataType dataType = retType = retArg == null ? null : retArg.getDasType().toDataType();
            if (retType == null || retType.typeName.equalsIgnoreCase("record") || retType.typeName.equals("setof") && "record".equalsIgnoreCase(retType.suffix)) {
                JBIterable args2 = JBIterable.from(target2.getArguments()).filter(o2 -> o2.getArgumentDirection().isOut());
                if (!args2.isEmpty()) {
                    return SqlFunctionCallExpressionImpl.createTypeFromColumns((Iterable<? extends DasTypedObject>)args2, qualifier);
                }
            } else if (retType.typeName.equals("setof") && retType.suffix != null) {
                SqlTypeElement typeElement;
                if (retArg instanceof SqlReturnsClause && (typeElement = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)((SqlReturnsClause)retArg).getTypeElement(), SqlTypeElement.class)) != null) {
                    return typeElement.getDasType();
                }
                return SqlImplUtil.rebuildDasType(DasUnresolvedTypeReference.of(DataTypeFactory.of(retType.suffix)), dialect, qualifier);
            }
        } else if (dbms.isMicrosoft() && target2.getRoutineKind() == DasRoutine.Kind.FUNCTION && retArg == null) {
            return SqlFunctionCallExpressionImpl.createTypeFromColumns((Iterable<? extends DasTypedObject>)target2.getDasChildren(ObjectKind.NONE).filter(DasTypedObject.class), qualifier);
        }
        return retArg == null ? DasTypeSystemBase.UNKNOWN : SqlFunctionCallExpressionImpl.createType(resolve2, retArg, ensureTable, qualifier);
    }

    @NotNull
    private static DasType getParamType(SqlElement element2) {
        DasType dasType;
        if (element2 instanceof DasTypeAwareObject) {
            DasTypeAwareObject obj2 = (DasTypeAwareObject)element2;
            dasType = obj2.getDasType();
        } else {
            dasType = DasTypeSystemBase.UNKNOWN;
        }
        if (dasType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(12);
        }
        return dasType;
    }

    private static DasType createTypeFromColumns(@NotNull Iterable<? extends DasTypedObject> args2, @NotNull PsiElement qualifier) {
        if (args2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(13);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(14);
        }
        int size = Iterables.size(args2);
        ArrayList<SqlImplUtil.Column> columns2 = new ArrayList<SqlImplUtil.Column>(size);
        for (DasTypedObject dasTypedObject : args2) {
            columns2.add(new SqlImplUtil.Column(dasTypedObject.getName(), dasTypedObject.getDasType(), (PsiElement)(dasTypedObject instanceof PsiElement ? (PsiElement)dasTypedObject : new FakeParameter(qualifier, dasTypedObject)), null));
        }
        return SqlImplUtil.createType(columns2, qualifier);
    }

    private static DasType createType(@NotNull PsiElement routine2, @NotNull DasArgument retArg, boolean ensureTable, @NotNull PsiElement qualifier) {
        DasType dasType;
        if (routine2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(15);
        }
        if (retArg == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(16);
        }
        if (qualifier == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(17);
        }
        if ((dasType = SqlFunctionCallExpressionImpl.getReturnType(routine2, retArg)) != DasTypeSystemBase.UNKNOWN && retArg instanceof SqlElement) {
            DasType res2;
            DasType dasType2 = res2 = ensureTable ? SqlTableTypeBase.ensureTableType(dasType, (PsiElement)((SqlElement)retArg), qualifier) : dasType;
            if (dasType instanceof SqlTableType) {
                String name2 = routine2 instanceof DasObject ? ((DasObject)routine2).getName() : (routine2 instanceof SqlExpression ? ((SqlExpression)routine2).getName() : null);
                res2 = ((SqlTableType)res2).alias(name2, qualifier, Collections.emptyList());
            }
            return res2;
        }
        if (!ensureTable) {
            return dasType;
        }
        List<SqlImplUtil.Column> columns2 = Collections.singletonList(new SqlImplUtil.Column(retArg.getName(), dasType, (PsiElement)(retArg instanceof PsiElement ? (PsiElement)retArg : new FakeParameter(qualifier, retArg)), null));
        return SqlImplUtil.createType(columns2, qualifier);
    }

    private static DasType getReturnType(@NotNull PsiElement routine2, @NotNull DasArgument retArg) {
        if (routine2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(18);
        }
        if (retArg == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(19);
        }
        DasType dasType = null;
        Dbms dbms = SqlImplUtil.getSqlDialectSafe(routine2).getDbms();
        if (retArg instanceof SqlTypedDefinition) {
            SqlTypedDefinition typedDef = (SqlTypedDefinition)retArg;
            dasType = typedDef.getDasType();
            if (dbms.isPostgres() && dasType instanceof DasSetofType) {
                DasSetofType dasSetofType = (DasSetofType)dasType;
                return dasSetofType.getInnerType();
            }
        }
        DataType dataType = retArg.getDasType().toDataType();
        if (dbms.isPostgres()) {
            dataType = SqlFunctionCallExpressionImpl.trimSetOf(dataType);
        }
        return dasType != null ? dasType : SqlFunctionCallExpressionImpl.getDasType(routine2, DasUnresolvedTypeReference.of(dataType));
    }

    @NotNull
    private static DataType trimSetOf(DataType dataType) {
        DataType dataType2 = dataType.typeName.equals("setof") && dataType.suffix != null ? DataTypeFactory.of(dataType.suffix) : dataType;
        if (dataType2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(20);
        }
        return dataType2;
    }

    private static DasType getDasType(@NotNull PsiElement routine2, @NotNull DasType dasType) {
        if (routine2 == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(21);
        }
        if (dasType == null) {
            SqlFunctionCallExpressionImpl.$$$reportNull$$$0(22);
        }
        if (dasType == DasTypeSystemBase.UNKNOWN) {
            return dasType;
        }
        return SqlImplUtil.rebuildDasType(dasType, SqlImplUtil.getSqlDialectSafe(routine2), routine2);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                SqlReferenceExpression nameElement = SqlFunctionCallExpressionImpl.this.getNameElement();
                return nameElement == null ? null : nameElement.getName();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return null;
            }
        };
    }

    @Nullable
    public BuiltinFunction getFunctionDefinition() {
        if (this.getParent() instanceof SqlScopingExpression) {
            return null;
        }
        SqlReferenceExpression nameElement = this.getNameElement();
        if (nameElement == null) {
            return null;
        }
        String functionName = nameElement.getName();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        BuiltinFunction definition2 = dialect.getSupportedFunctions().get(functionName);
        return definition2 == null || SqlImplUtil.hasLocationOf(definition2, dialect.getExpectedFunctionLocations((SqlExpression)nameElement)) ? definition2 : null;
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        return referenceElement == this.getNameElement() && this.getFirstChild() != this.getLastChild() ? ObjectKind.ROUTINE : super.getExpectedReferenceTargetType(referenceElement);
    }

    private boolean isFunctionWithColumnQualifier(SqlScopeProcessor processor2) {
        if (!processor2.getDialect().getDbms().isMicrosoft()) {
            return false;
        }
        BuiltinFunction funDef = this.getFunctionDefinition();
        if (funDef == null) {
            return false;
        }
        String name2 = funDef.getName();
        return name2.equalsIgnoreCase("CONTAINSTABLE") || name2.equalsIgnoreCase("FREETEXTTABLE");
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor2, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor2, ObjectKind.ARGUMENT)) {
            return true;
        }
        if (!SqlFunctionCallExpressionImpl.processNamedArgument((Processor<? super DasSymbol>)((Processor)e2 -> processor2.execute(e2, state)), this.getNameElement(), place)) {
            return false;
        }
        if (processor2.mayAccept(ObjectKind.COLUMN) && this.isFunctionWithColumnQualifier(processor2)) {
            SqlExpressionList parameterList = this.getParameterList();
            List expressions2 = parameterList != null ? parameterList.getExpressionList() : Collections.emptyList();
            for (SqlExpression expression : expressions2) {
                if (!(expression instanceof SqlReferenceExpression) || ((SqlReferenceExpression)expression).getKind() != ObjectKind.TABLE || SqlImplUtil.processFromReferences(processor2, state, expression, place, lastParent)) continue;
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor2, state, lastParent, place);
    }

    public static boolean processNamedArgument(Processor<? super DasSymbol> processor2, SqlReferenceExpression ref2, PsiElement place) {
        SqlNamedParameterValueExpression expr = (SqlNamedParameterValueExpression)((Object)ObjectUtils.tryCast((Object)(place == null ? null : place.getParent()), SqlNamedParameterValueExpression.class));
        if (expr != null && place == expr.getLOperand()) {
            SqlFunctionCallExpressionImpl.processParameters(ref2, processor2, place);
            return false;
        }
        return true;
    }

    public static boolean processParameters(@Nullable SqlReferenceExpression fooRef, Processor<? super DasSymbol> processor2, PsiElement place) {
        if (fooRef == null) {
            return true;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)fooRef);
        Case casing = dialect.getCasing((ObjectKind)ObjectKind.ARGUMENT, null).plain;
        BuiltinFunction definition2 = dialect.getSupportedFunctions().get(fooRef.getName());
        if (definition2 != null) {
            JBIterable params2 = ((JBTreeTraverser)JBTreeTraverser.from(SqlFunctionCallExpressionImpl::getParameters).withRoots((Iterable)JBIterable.of((Object[])definition2.getPrototypes()))).filter(BuiltinFunction.SimpleParameter.class);
            for (BuiltinFunction.SimpleParameter param : params2) {
                String name2 = casing.apply(param.getName());
                DasType dasType = param.getType().getDasType();
                if (dasType == null || processor2.process((Object)DasSymbolUtil.createSimpleVariable((SqlElement)fooRef, name2, dasType))) continue;
                return false;
            }
        }
        for (ResolveResult res2 : fooRef.multiResolve(false)) {
            if (dialect.processNamedArgumentCandidates(DasSymbolUtil.getSymbol(res2), processor2, fooRef.getProject())) continue;
            return false;
        }
        return true;
    }

    private static Iterable<? extends BuiltinFunction.Parameter> getParameters(BuiltinFunction.Parameter p2) {
        return p2 instanceof BuiltinFunction.ParameterBlock ? JBIterable.of((Object[])((BuiltinFunction.ParameterBlock)p2).getParams()) : JBIterable.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 12, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routineElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "retArg";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getP0Type";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "trimSetOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 12: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFunctionReturnType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReturnTypeForCallWithColumns";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBuiltinFunctionReturnType";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRoutineType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromColumns";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDasType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 12, 20 -> new IllegalStateException(string);
        };
    }

    public static class FakeParameter
    extends SqlFileImpl.FakeDefinition
    implements DasTypedObject {
        private final PsiElement myParent;
        @Nullable
        private final DasTypedObject myDelegate;

        public FakeParameter(@NotNull PsiElement parent2, @NotNull DasTypedObject parameter) {
            if (parent2 == null) {
                FakeParameter.$$$reportNull$$$0(0);
            }
            if (parameter == null) {
                FakeParameter.$$$reportNull$$$0(1);
            }
            this(parent2, StringUtil.notNullize((String)parameter.getName()), parameter);
        }

        public FakeParameter(@NotNull PsiElement parent2, @NotNull String name2, @Nullable DasTypedObject delegate) {
            if (parent2 == null) {
                FakeParameter.$$$reportNull$$$0(2);
            }
            if (name2 == null) {
                FakeParameter.$$$reportNull$$$0(3);
            }
            super(parent2, name2);
            this.myParent = parent2;
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myDelegate != null ? this.myDelegate.getDasType() : DasTypeSystemBase.UNKNOWN;
            if (dasType == null) {
                FakeParameter.$$$reportNull$$$0(4);
            }
            return dasType;
        }

        @Override
        public boolean isNotNull() {
            return this.myDelegate != null && this.myDelegate.isNotNull();
        }

        @Override
        @Nullable
        public String getDefault() {
            return this.myDelegate == null ? null : this.myDelegate.getDefault();
        }

        public boolean isNameQuoted() {
            return DbSqlUtilCore.isQuoted(this.myDelegate);
        }

        public int getTextOffset() {
            return this.myParent.getTextOffset();
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.ARGUMENT;
            if (objectKind == null) {
                FakeParameter.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @Override
        public String getTypeName() {
            if (this.myDelegate != null) {
                SqlLanguageDialectEx sqlDialect2 = SqlImplUtil.getSqlDialectSafe(this.getParent());
                DatabaseDialectEx dbDialect = sqlDialect2.getDatabaseDialect();
                return new DdlBuilder().applyCodeStyle(this.getProject(), sqlDialect2).withDialect(dbDialect).type(this.myDelegate).getStatement();
            }
            return super.getTypeName();
        }

        @Override
        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallExpressionImpl$FakeParameter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

