/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlSplitInsertStatementIntention;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/intentions/SqlSplitInsertStatementIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "createValuesExpression", "Lcom/intellij/sql/psi/SqlValuesExpression;", "text", "", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "project", "Lcom/intellij/openapi/project/Project;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getInsertIfApplicable", "Lcom/intellij/sql/psi/SqlInsertStatement;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "withNewRow", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "withNewValues", "values", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlSplitInsertStatementIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlSplitInsertStatementIntention.kt\ncom/intellij/sql/intentions/SqlSplitInsertStatementIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1549#2:72\n1620#2,3:73\n1#3:76\n*S KotlinDebug\n*F\n+ 1 SqlSplitInsertStatementIntention.kt\ncom/intellij/sql/intentions/SqlSplitInsertStatementIntention\n*L\n62#1:72\n62#1:73,3\n*E\n"})
public final class SqlSplitInsertStatementIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.split.insert.statement", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final SqlInsertStatement getInsertIfApplicable(PsiElement element2) {
        SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlInsertStatement.class);
        if (sqlInsertStatement == null) {
            return null;
        }
        SqlInsertStatement insertStatement = sqlInsertStatement;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
        if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) == null) {
            return null;
        }
        SqlInsertDmlInstruction valuesExpression = sqlInsertDmlInstruction;
        if (valuesExpression.getExpressions().size() <= 1) {
            return null;
        }
        return insertStatement;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getInsertIfApplicable(element2) != null;
    }

    private final SqlValuesExpression createValuesExpression(String text2, SqlLanguageDialectEx dialect, Project project) {
        SqlStatement statement2 = SqlPsiElementFactory.createStatementFromText("INSERT INTO foo " + text2, dialect, project, null);
        SqlInsertStatement sqlInsertStatement = statement2 instanceof SqlInsertStatement ? (SqlInsertStatement)statement2 : null;
        return sqlInsertStatement != null && (sqlInsertStatement = sqlInsertStatement.getDmlInstruction()) != null ? sqlInsertStatement.getValuesExpression() : null;
    }

    private final SqlValuesExpression withNewRow(SqlValuesExpression $this$withNewRow, SqlExpression expression) {
        SqlValuesExpression copy;
        block0: {
            PsiElement psiElement = $this$withNewRow.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlValuesExpression");
            copy = (SqlValuesExpression)psiElement;
            JBIterable jBIterable = copy.getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getExpressions(...)");
            SqlExpression sqlExpression = (SqlExpression)CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
            if (sqlExpression == null) break block0;
            sqlExpression.replace((PsiElement)expression);
        }
        return copy;
    }

    private final SqlInsertStatement withNewValues(SqlInsertStatement $this$withNewValues, SqlValuesExpression values2) {
        SqlInsertStatement copy;
        block0: {
            PsiElement psiElement = $this$withNewValues.copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlInsertStatement");
            copy = (SqlInsertStatement)psiElement;
            SqlInsertDmlInstruction sqlInsertDmlInstruction = copy.getDmlInstruction();
            if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) == null) break block0;
            sqlInsertDmlInstruction.replace((PsiElement)values2);
        }
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Template template;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlInsertStatement sqlInsertStatement = this.getInsertIfApplicable(element2);
        if (sqlInsertStatement == null) {
            return;
        }
        SqlInsertStatement insertStatement = sqlInsertStatement;
        String string = DbSqlUtil.getDelimiterAt(element2.getContainingFile(), element2.getTextRange().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDelimiterAt(...)");
        String delimiter = string;
        String string2 = UtilsKt.getValuesKeyword(insertStatement);
        if (string2 == null) {
            return;
        }
        String valuesKeyword2 = string2;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
        Intrinsics.checkNotNull((Object)sqlInsertDmlInstruction);
        SqlValuesExpression sqlValuesExpression = sqlInsertDmlInstruction.getValuesExpression();
        Intrinsics.checkNotNull((Object)sqlValuesExpression);
        SqlValuesExpression originalValues = sqlValuesExpression;
        SqlValuesExpression sqlValuesExpression2 = this.createValuesExpression(valuesKeyword2 + " (1)", dialect, project);
        if (sqlValuesExpression2 == null) {
            return;
        }
        SqlValuesExpression dummyValues = sqlValuesExpression2;
        List list = originalValues.getExpressions().map(arg_0 -> SqlSplitInsertStatementIntention.invoke$lambda$0((Function1)new Function1<SqlExpression, SqlValuesExpression>(this, dummyValues){
            final /* synthetic */ SqlSplitInsertStatementIntention this$0;
            final /* synthetic */ SqlValuesExpression $dummyValues;
            {
                this.this$0 = $receiver;
                this.$dummyValues = $dummyValues;
                super(1);
            }

            public final SqlValuesExpression invoke(SqlExpression it2) {
                Intrinsics.checkNotNull((Object)it2);
                return SqlSplitInsertStatementIntention.access$withNewRow(this.this$0, this.$dummyValues, it2);
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List valuesExpressions2 = list;
        originalValues.replace((PsiElement)dummyValues);
        Iterable $this$map$iv = valuesExpressions2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            SqlValuesExpression sqlValuesExpression3 = (SqlValuesExpression)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            collection2.add(this.withNewValues(insertStatement, (SqlValuesExpression)it2));
        }
        List insertStatements = (List)destination$iv$iv;
        String fullText2 = CollectionsKt.joinToString$default((Iterable)insertStatements, (CharSequence)delimiter, null, null, (int)0, null, (Function1)invoke.fullText.1.INSTANCE, (int)30, null);
        editor2.getCaretModel().moveToOffset(insertStatement.getTextRange().getStartOffset());
        insertStatement.delete();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template it3 = template = templateManager.createTemplate("", "", fullText2);
        boolean bl = false;
        it3.setToReformat(true);
        Template template2 = template;
        templateManager.startTemplate(editor2, template2);
    }

    private static final SqlValuesExpression invoke$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SqlValuesExpression)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ SqlValuesExpression access$withNewRow(SqlSplitInsertStatementIntention $this, SqlValuesExpression $receiver, SqlExpression expression) {
        return $this.withNewRow($receiver, expression);
    }
}

