/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011H\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0096\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceGroupByWithDistinctIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "createDistinctOption", "Lcom/intellij/sql/psi/SqlSelectOption;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "findApplicableGroupBy", "Lcom/intellij/sql/psi/SqlGroupByClause;", "context", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlReplaceGroupByWithDistinctIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlReplaceGroupByWithDistinctIntention.kt\ncom/intellij/sql/intentions/SqlReplaceGroupByWithDistinctIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1747#2,3:70\n1549#2:73\n1620#2,3:74\n1620#2,2:81\n1622#2:84\n1620#2,3:85\n11065#3:77\n11400#3,3:78\n1#4:83\n*S KotlinDebug\n*F\n+ 1 SqlReplaceGroupByWithDistinctIntention.kt\ncom/intellij/sql/intentions/SqlReplaceGroupByWithDistinctIntention\n*L\n52#1:70,3\n56#1:73\n56#1:74,3\n59#1:81,2\n59#1:84\n60#1:85,3\n58#1:77\n58#1:78,3\n*E\n"})
public final class SqlReplaceGroupByWithDistinctIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.name.replace.group.by.with.distinct", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.findApplicableGroupBy(element2) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        SqlSelectOption optionToReplace;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlGroupByClause sqlGroupByClause = this.findApplicableGroupBy(element2);
        if (sqlGroupByClause == null) {
            return;
        }
        SqlGroupByClause groupBy = sqlGroupByClause;
        SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)groupBy), SqlQueryExpression.class);
        if (sqlQueryExpression == null) {
            return;
        }
        SqlQueryExpression query = sqlQueryExpression;
        SqlSelectClause sqlSelectClause = query.getSelectClause();
        if (sqlSelectClause == null) {
            return;
        }
        SqlSelectClause selectClause = sqlSelectClause;
        List list = selectClause.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptions(...)");
        List options2 = list;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)query);
        Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialectEx, (String)"getSqlDialectSafe(...)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        SqlSelectOption distinctOption = this.createDistinctOption(dialect, project);
        SqlSelectOption sqlSelectOption = optionToReplace = dbms2.isCassandra() || dbms2.isClickHouse() ? null : (SqlSelectOption)CollectionsKt.firstOrNull((List)options2);
        if (optionToReplace != null) {
            optionToReplace.replace((PsiElement)distinctOption);
        } else {
            SqlSelectOption sqlSelectOption2 = (SqlSelectOption)CollectionsKt.lastOrNull((List)options2);
            PsiElement anchor2 = sqlSelectOption2 != null ? (PsiElement)sqlSelectOption2 : selectClause.getFirstChild();
            PsiElement newOption = selectClause.addAfter((PsiElement)distinctOption, anchor2);
            CodeStyleManager.getInstance((Project)project).reformat(newOption);
        }
        groupBy.delete();
    }

    /*
     * WARNING - void declaration
     */
    private final SqlGroupByClause findApplicableGroupBy(PsiElement context) {
        SqlGroupByClause sqlGroupByClause;
        void $this$mapTo$iv;
        void $this$mapTo$iv2;
        Collection destination$iv$iv;
        int n;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        SqlSelectClause selectClause;
        SqlGroupByClause groupBy;
        block20: {
            if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)context), (Object)SqlCommonKeywords.SQL_GROUP)) {
                return null;
            }
            PsiElement psiElement = context.getParent();
            SqlGroupByClause sqlGroupByClause2 = psiElement instanceof SqlGroupByClause ? (SqlGroupByClause)psiElement : null;
            if (sqlGroupByClause2 == null) {
                return null;
            }
            groupBy = sqlGroupByClause2;
            SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)groupBy), SqlQueryExpression.class);
            if (sqlQueryExpression == null) {
                return null;
            }
            SqlQueryExpression query = sqlQueryExpression;
            SqlSelectClause sqlSelectClause = query.getSelectClause();
            if (sqlSelectClause == null) {
                return null;
            }
            selectClause = sqlSelectClause;
            List list = selectClause.getOptions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptions(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    SqlSelectOption it2 = (SqlSelectOption)element$iv2;
                    boolean bl2 = false;
                    boolean bl3 = StringsKt.equals((String)it2.getName(), (String)"distinct", (boolean)true) || StringsKt.equals((String)it2.getName(), (String)"distinctrow", (boolean)true);
                    if (!bl3) continue;
                    bl = true;
                    break block20;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        List list = selectClause.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExpressions(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv;
        SqlExpression[] destination$iv$iv2 = (SqlExpression[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            SqlExpression sqlExpression = (SqlExpression)item$iv$iv;
            object = destination$iv$iv2;
            n = 0;
            SqlReferenceExpression sqlReferenceExpression = it3 instanceof SqlReferenceExpression ? (SqlReferenceExpression)it3 : null;
            if (sqlReferenceExpression == null) {
                return null;
            }
            object.add(sqlReferenceExpression);
        }
        List outputRefs = (List)destination$iv$iv2;
        SqlExpression[] $i$f$map22 = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)groupBy), SqlExpression.class);
        if ($i$f$map22 != null) {
            Iterator $this$mapTo$iv$iv2;
            void $this$map$iv2;
            destination$iv$iv2 = $i$f$map22;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv2;
            destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            int n3 = ((void)$this$mapTo$iv$iv2).length;
            for (n = 0; n < n3; ++n) {
                void it4;
                void item$iv$iv;
                void var17_30 = item$iv$iv = $this$mapTo$iv$iv2[n];
                object = destination$iv$iv;
                boolean bl4 = false;
                SqlReferenceExpression sqlReferenceExpression = it4 instanceof SqlReferenceExpression ? (SqlReferenceExpression)it4 : null;
                if (sqlReferenceExpression == null) {
                    return null;
                }
                object.add(sqlReferenceExpression);
            }
        } else {
            return null;
        }
        List groupRefs = (List)destination$iv$iv;
        $this$mapTo$iv$iv = outputRefs;
        Iterable destination$iv = new HashSet();
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv2) {
            Object object2;
            void it5;
            SqlReferenceExpression $i$f$mapTo2 = (SqlReferenceExpression)item$iv;
            object = destination$iv;
            boolean bl5 = false;
            Collection collection2 = SqlImplUtil.resolveQualified((SqlReferenceExpression)it5);
            if (collection2.isEmpty()) {
                boolean bl6 = false;
                object2 = it5.getText();
            } else {
                object2 = collection2;
            }
            object.add(object2);
        }
        HashSet outputTargets = (HashSet)destination$iv;
        destination$iv = groupRefs;
        Collection destination$iv2 = new HashSet();
        boolean $i$f$mapTo3 = false;
        for (Object item$iv : $this$mapTo$iv) {
            Object object3;
            void it6;
            SqlReferenceExpression bl5 = (SqlReferenceExpression)item$iv;
            object = destination$iv2;
            boolean bl7 = false;
            Collection collection3 = SqlImplUtil.resolveQualified((SqlReferenceExpression)it6);
            if (collection3.isEmpty()) {
                boolean bl8 = false;
                object3 = it6.getText();
            } else {
                object3 = collection3;
            }
            object.add(object3);
        }
        HashSet groupTargets = (HashSet)destination$iv2;
        SqlGroupByClause it7 = sqlGroupByClause = groupBy;
        boolean bl9 = false;
        return Intrinsics.areEqual((Object)outputTargets, (Object)groupTargets) ? sqlGroupByClause : null;
    }

    private final SqlSelectOption createDistinctOption(SqlLanguageDialect dialect, Project project) {
        String string = new DdlBuilder().configureBuilder(project, dialect).keyword("distinct").getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        String text2 = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText("select " + text2 + " id from foo", dialect, project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        SqlQueryExpression query = sqlQueryExpression;
        SqlSelectClause sqlSelectClause = query.getSelectClause();
        Intrinsics.checkNotNull((Object)sqlSelectClause);
        List list = sqlSelectClause.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOptions(...)");
        Object object = CollectionsKt.first((List)list);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return (SqlSelectOption)object;
    }
}

