/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlQuoteIdentifierIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "Lcom/intellij/codeInsight/intention/PriorityAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPriority", "Lcom/intellij/codeInsight/intention/PriorityAction$Priority;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlQuoteIdentifierIntention
extends SqlBaseElementAtCaretIntentionAction
implements PriorityAction {
    @NotNull
    public PriorityAction.Priority getPriority() {
        return PriorityAction.Priority.TOP;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"quickfix.name.quote.identifier", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiFile file = element2.getContainingFile();
        if (!(file instanceof SqlFile)) {
            return false;
        }
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element2);
        if (sqlIdentifier == null) {
            return false;
        }
        SqlIdentifier identifier = sqlIdentifier;
        ObjectKind kind = SqlImplUtil.getIdentifierKind(identifier);
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.OPERATOR)) {
            return false;
        }
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)identifier);
        if (dbms.isTransactSql() && Intrinsics.areEqual((Object)kind, (Object)SqlDbElementType.LABEL)) {
            return false;
        }
        return !identifier.isQuotedIdentifier();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element2);
        if (sqlIdentifier == null) {
            return;
        }
        SqlIdentifier identifier = sqlIdentifier;
        SqlImplUtil.quoteIdentifier(project, identifier, SqlImplUtil.getSqlDialectSafe((PsiElement)identifier));
    }
}

