/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.PsiTable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlIntroduceTableAliasIntention;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.Query;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0017J!\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0004J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlInlineTableAliasIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "findAsExpression", "Lcom/intellij/sql/psi/SqlAsExpression;", "element", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "asExpression", "isAvailable", "", "isSuitable", "intellij.database.sql.impl"})
@SourceDebugExtension(value={"SMAP\nSqlInlineTableAliasIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlInlineTableAliasIntention.kt\ncom/intellij/sql/intentions/SqlInlineTableAliasIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1855#3,2:96\n*S KotlinDebug\n*F\n+ 1 SqlInlineTableAliasIntention.kt\ncom/intellij/sql/intentions/SqlInlineTableAliasIntention\n*L\n65#1:96,2\n*E\n"})
public final class SqlInlineTableAliasIntention
extends SqlBaseElementAtCaretIntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"inline.table.alias", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.isSuitable(this.findAsExpression(element2));
    }

    public final boolean isSuitable(@Nullable SqlAsExpression asExpression) {
        if (asExpression == null || !(asExpression.getExpression() instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlExpression sqlExpression = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        PsiElement element2 = ((SqlReferenceExpression)sqlExpression).resolve();
        if (!(element2 instanceof PsiTable)) {
            return false;
        }
        SqlResultSetExpression topExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, element2);
        if (topExpression == null) {
            return false;
        }
        Collection<String> collection2 = SqlNamesGenerator.collectExistingNames((PsiElement)topExpression, (Condition<? super PsiElement>)((Condition)arg_0 -> SqlInlineTableAliasIntention.isSuitable$lambda$0((Function1)new Function1<PsiElement, Boolean>(asExpression){
            final /* synthetic */ SqlAsExpression $asExpression;
            {
                this.$asExpression = $asExpression;
                super(1);
            }

            @NotNull
            public final Boolean invoke(PsiElement it2) {
                if (Intrinsics.areEqual((Object)it2, (Object)this.$asExpression)) {
                    return true;
                }
                if (it2 instanceof SqlNameElement && Intrinsics.areEqual((Object)PsiTreeUtil.getParentOfType((PsiElement)it2, SqlDefinition.class), (Object)this.$asExpression)) {
                    return true;
                }
                if (it2 instanceof SqlReferenceExpression) {
                    return true;
                }
                return false;
            }
        }, arg_0)));
        SqlExpression sqlExpression2 = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        return !collection2.contains(((SqlReferenceExpression)sqlExpression2).getName());
    }

    private final SqlAsExpression findAsExpression(PsiElement element2) {
        Object object;
        SqlAsExpression sqlAsExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlAsExpression.class);
        if (sqlAsExpression != null) {
            SqlAsExpression sqlAsExpression2;
            SqlAsExpression it2 = sqlAsExpression2 = sqlAsExpression;
            boolean bl = false;
            object = PsiTreeUtil.isAncestor((PsiElement)((PsiElement)it2.getNameElement()), (PsiElement)element2, (boolean)false) ? sqlAsExpression2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlAsExpression sqlAsExpression = this.findAsExpression(element2);
        Intrinsics.checkNotNull((Object)sqlAsExpression);
        this.invoke(sqlAsExpression);
    }

    public final void invoke(@NotNull SqlAsExpression asExpression) {
        Intrinsics.checkNotNullParameter((Object)asExpression, (String)"asExpression");
        SqlExpression sqlExpression = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        PsiElement psiElement = ((SqlReferenceExpression)sqlExpression).resolve();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.database.model.PsiTable");
        PsiTable psiTable = (PsiTable)psiElement;
        SqlResultSetExpression sqlResultSetExpression = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)asExpression, psiTable);
        Intrinsics.checkNotNull((Object)sqlResultSetExpression);
        SqlResultSetExpression topExpression = sqlResultSetExpression;
        SqlExpression sqlExpression2 = asExpression.getExpression();
        Intrinsics.checkNotNull((Object)sqlExpression2, (String)"null cannot be cast to non-null type com.intellij.sql.psi.SqlReferenceExpression");
        SqlReferenceExpression expression = (SqlReferenceExpression)sqlExpression2;
        String text2 = expression.getText();
        SqlEditorOptions sqlEditorOptions = SqlEditorOptions.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)sqlEditorOptions, (String)"getInstance(...)");
        SqlEditorOptions options2 = sqlEditorOptions;
        SqlEditorOptions.QualificationType qualificationType = options2.getTableQualification().and(options2.getRefactoringQualification());
        Intrinsics.checkNotNullExpressionValue((Object)qualificationType, (String)"and(...)");
        SqlEditorOptions.QualificationType tableQualification = qualificationType;
        Query query = ReferencesSearch.search((PsiElement)((PsiElement)asExpression), (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)topExpression)));
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        Iterable $this$forEach$iv = (Iterable)query;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlReferenceExpression referenceFromText;
            PsiElement psiElement2;
            PsiReference it2 = (PsiReference)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2.getElement(), (String)"getElement(...)");
            if (!(psiElement2 instanceof SqlReferenceExpression)) continue;
            PsiElement parent2 = ((SqlReferenceExpression)psiElement2).getParent();
            if (parent2 instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)((SqlReferenceExpression)parent2).getQualifierExpression(), (Object)psiElement2) && tableQualification != SqlEditorOptions.QualificationType.ALWAYS) {
                SqlIdentifier sqlIdentifier = ((SqlReferenceExpression)parent2).getIdentifier();
                String name2 = sqlIdentifier != null ? sqlIdentifier.getText() : null;
                SqlResultSetExpression top = SqlIntroduceTableAliasIntention.Companion.getTopExpression((SqlExpression)parent2, psiTable);
                if (name2 != null && top != null && !SqlNamesGenerator.collectExistingNames((PsiElement)top, (Condition<? super PsiElement>)((Condition)arg_0 -> SqlInlineTableAliasIntention.invoke$lambda$3$lambda$2((Function1)new Function1<PsiElement, Boolean>(asExpression){
                    final /* synthetic */ SqlAsExpression $asExpression;
                    {
                        this.$asExpression = $asExpression;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(PsiElement node2) {
                        PsiElement resolved;
                        SqlExpression qualifierExpression;
                        if (node2 instanceof SqlReferenceExpression && (qualifierExpression = ((SqlReferenceExpression)node2).getQualifierExpression()) instanceof SqlReferenceExpression && Intrinsics.areEqual((Object)(resolved = ((SqlReferenceExpression)qualifierExpression).resolve()), (Object)this.$asExpression)) {
                            return true;
                        }
                        return false;
                    }
                }, arg_0))).contains(name2)) {
                    SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(name2, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2);
                    Intrinsics.checkNotNull((Object)sqlReferenceExpression);
                    parent2.replace((PsiElement)sqlReferenceExpression);
                    continue;
                }
            }
            Intrinsics.checkNotNull((Object)SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe(psiElement2), ((SqlReferenceExpression)psiElement2).getReferenceElementType(), psiElement2));
            psiElement2.replace((PsiElement)referenceFromText);
        }
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText(text2, SqlImplUtil.getSqlDialectSafe((PsiElement)asExpression), expression.getReferenceElementType(), (PsiElement)asExpression);
        Intrinsics.checkNotNull((Object)sqlReferenceExpression);
        asExpression.replace((PsiElement)sqlReferenceExpression);
    }

    private static final boolean isSuitable$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean invoke$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

